/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class SoftwareCounterAttachment
extends AbstractFreeAttachment {
    private static final long serialVersionUID = -41475068881266731L;
    public final CounterType counterType;
    public final long counterValue;
    public final Long programId;

    public SoftwareCounterAttachment(CounterType counterType, Long programId, long counterValue) throws TraceParseException {
        this.programId = programId;
        this.counterValue = counterValue;
        if (counterType == null) {
            throw new TraceParseException("Counter type is invalid.");
        }
        this.counterType = counterType;
    }

    @Override
    public void doMidstreamProcessingForAsset(@NonNull TraceStateSnapshot currentState, @NonNull com.arm.mgd.core.asset.IAssetItem assetObject) {
        assert (assetObject instanceof GlProgramAsset);
        GlProgramAsset program = (GlProgramAsset)assetObject;
        switch (this.counterType) {
            case FRAGMENT_COUNT: {
                FrameRenderPass firstRenderPass;
                GlShaderAsset fragmentShader = program.getLinkedShader(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER);
                if (fragmentShader != null) {
                    fragmentShader.incrementCurrentFrameShaderInvocations(this.counterValue);
                }
                if ((firstRenderPass = ((Frame)NullUtils.neverNull((Object)this.getParentFunctionCall().getParentFrame())).getFirstRenderPass()) == null) break;
                FramebufferFeature currentFramebufferFeature = firstRenderPass.getEnabledFeature();
                FramebufferFeature newFramebufferFeature = new FramebufferFeature(FramebufferFeature.CaptureMode.FRAGMENT_COUNT, currentFramebufferFeature.isCaptureEnabled(), currentFramebufferFeature.isReplayEnabled());
                firstRenderPass.setFramebufferFeature(newFramebufferFeature);
                break;
            }
            case COMPUTE_LOCAL_WORKGROUP_X: 
            case COMPUTE_LOCAL_WORKGROUP_Y: 
            case COMPUTE_LOCAL_WORKGROUP_Z: {
                break;
            }
        }
    }

    @Override
    public <M, P extends IAssetItem<M, ?>> void doMidstreamProcessingForLightweightAsset(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject) throws Exception {
    }

    @Override
    public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> @NonNull V doMidstreamProcessingForLightweightAssetValue(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject, @NonNull V value) throws Exception {
        return value;
    }

    @Override
    public void process(@NonNull TraceStateSnapshot currentState) {
        block5: {
            try {
                GlProgramAsset program = (GlProgramAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC).get(this.programId);
                if (program != null) {
                    this.doMidstreamProcessingForAsset(currentState, program);
                } else assert (false);
            }
            catch (NullPointerException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public static enum CounterType {
        FRAGMENT_COUNT(1),
        COMPUTE_LOCAL_WORKGROUP_X(2),
        COMPUTE_LOCAL_WORKGROUP_Y(3),
        COMPUTE_LOCAL_WORKGROUP_Z(4);

        private final int value;

        public static CounterType getCounterType(int value) {
            CounterType[] counterTypeArray = CounterType.values();
            int n = counterTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CounterType counterType = counterTypeArray[n2];
                if (counterType.value == value) {
                    return counterType;
                }
                ++n2;
            }
            return null;
        }

        private CounterType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

