/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.FunctionCallRange;
import com.arm.mgd.core.target.data.IFunctionCallRangeItem;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public final class SingleFunctionCallItem
implements IFunctionCallRangeItem,
Serializable {
    private static final long serialVersionUID = -3410751054836504871L;
    private final int index;

    public SingleFunctionCallItem(@NonNull FunctionCall functionCall) {
        this.index = functionCall.getIndex();
    }

    @Override
    public boolean canBeExtendedBy(@NonNull FunctionCall functionCall) {
        return this.index + 1 == functionCall.getIndex();
    }

    @Override
    public int compareContains(@NonNull FunctionCall functionCall) {
        if (this.index < functionCall.getIndex()) {
            return -1;
        }
        if (this.index > functionCall.getIndex()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getFirstFunctionIndex() {
        return this.index;
    }

    @Override
    public int getLastFunctionCallIndex() {
        return this.index;
    }

    @Override
    public boolean isBefore(@NonNull FunctionCall functionCall) {
        return this.index < functionCall.getIndex();
    }

    @Override
    public @NonNull IFunctionCallRangeItem replaceByExtension(@NonNull FunctionCall functionCall) {
        assert (this.canBeExtendedBy(functionCall));
        return new FunctionCallRange(this.index, functionCall.getIndex());
    }

    public String toString() {
        return String.format("[%s, %s]", String.valueOf(this.index), String.valueOf(this.index));
    }
}

