/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.ProgramColour;
import com.arm.mgd.core.target.data.ProgramGeometryShaderProperties;
import com.arm.mgd.core.target.data.ProgramResourceDescriptorMap;
import com.arm.mgd.core.target.data.ProgramTessellationShaderProperties;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.attachments.ShaderProgramAttachmentLightweightProcessor;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ShaderProgramAttachment
extends AbstractFreeAttachment {
    private static final long serialVersionUID = 3419704919912262102L;
    public final @Nullable ProgramGeometryShaderProperties geometryShaderProperties;
    public final @NonNull ProgramColour programColor;
    public final @NonNull Long programId;
    public final @NonNull ProgramResourceDescriptorMap programResources;
    public final @Nullable ProgramTessellationShaderProperties tessellationShaderProperties;

    public ShaderProgramAttachment(long programId, float shaderRed, float shaderGreen, float shaderBlue, @NonNull ProgramResourceDescriptorMap programResources, @Nullable ProgramGeometryShaderProperties geometryShaderProperties, @Nullable ProgramTessellationShaderProperties tessellationShaderProperties) {
        this.programId = NullUtils.longValueOf((long)programId);
        this.programColor = new ProgramColour(shaderRed, shaderGreen, shaderBlue, 1.0f);
        this.programResources = programResources;
        this.geometryShaderProperties = geometryShaderProperties;
        this.tessellationShaderProperties = tessellationShaderProperties;
    }

    @Override
    public void doMidstreamProcessingForAsset(@NonNull TraceStateSnapshot currentState, @NonNull com.arm.mgd.core.asset.IAssetItem assetObject) {
        assert (assetObject instanceof GlProgramAsset);
        GlProgramAsset program = (GlProgramAsset)assetObject;
        program.setColor(this.programColor);
        program.setProgramResourceDescriptor(this.programResources);
        program.addUniformBufferBlockUniforms(currentState, this.getParentFunctionCall());
        program.setGeometryShaderProperties(this.geometryShaderProperties);
    }

    @Override
    public <M, P extends IAssetItem<M, ?>> void doMidstreamProcessingForLightweightAsset(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject) throws Exception {
        assert (assetObject instanceof com.arm.mgd.lightweight.asset.gles.GlProgramAsset);
        com.arm.mgd.lightweight.asset.gles.GlProgramAsset programAsset = (com.arm.mgd.lightweight.asset.gles.GlProgramAsset)assetObject;
        programAsset.replaceTransientState(this.getParentFunctionCall(), this.programColor, this.programResources);
    }

    @Override
    public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> @NonNull V doMidstreamProcessingForLightweightAssetValue(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject, @NonNull V value) throws Exception {
        return value;
    }

    public @Nullable ProgramGeometryShaderProperties getGeometryShaderProperties() {
        return this.geometryShaderProperties;
    }

    public @NonNull ProgramColour getProgramColor() {
        return this.programColor;
    }

    public @NonNull Long getProgramId() {
        return this.programId;
    }

    public @NonNull ProgramResourceDescriptorMap getProgramResources() {
        return this.programResources;
    }

    public @Nullable ProgramTessellationShaderProperties getTessellationShaderProperties() {
        return this.tessellationShaderProperties;
    }

    @Override
    public void process(TraceStateSnapshot currentState) {
        GlProgramAsset program = (GlProgramAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC).get(this.programId);
        if (program != null) {
            this.doMidstreamProcessingForAsset(currentState, program);
        }
    }

    @Override
    public <M> void processLightweightPostCallProcessor(@NonNull Class<M> clazz, @NonNull ILightweightAssetProcessorCallbacks<M> callbacks) throws Exception {
        assert (clazz == GLESApi.class);
        ShaderProgramAttachmentLightweightProcessor.CallProcessor processor = new ShaderProgramAttachmentLightweightProcessor.CallProcessor(this);
        processor.execute(callbacks, this.getParentFunctionCall());
    }
}

