/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.programvariable.ShaderAttribute;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractShaderParameterAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class ShaderAttributeAttachment
extends AbstractShaderParameterAttachment {
    private static final long serialVersionUID = 8236747660787982486L;

    public ShaderAttributeAttachment(long programId, int index, int size, AbstractConstantOrAliasSpecExtended type, String name) {
        super(programId, index, size, type, name);
    }

    @Override
    public void doMidstreamProcessingForAsset(@NonNull TraceStateSnapshot currentState, @NonNull com.arm.mgd.core.asset.IAssetItem assetObject) {
        assert (assetObject instanceof GlProgramAsset);
        GlProgramAsset programAsset = (GlProgramAsset)assetObject;
        int columnIndex = 0;
        while (columnIndex < this.type.getNumberOfColumnsAsInt()) {
            StringBuilder composedName = new StringBuilder(this.name);
            if (columnIndex > 0) {
                composedName.append('+').append(columnIndex).toString();
            }
            programAsset.addAttribute(new ShaderAttribute(currentState.asSnapshotAssetParent(), this.getParentFunctionCall(), this.index + columnIndex, this.size, this.type, (String)NullUtils.neverNull((Object)composedName.toString())));
            ++columnIndex;
        }
    }

    @Override
    public <M, P extends IAssetItem<M, ?>> void doMidstreamProcessingForLightweightAsset(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject) throws Exception {
    }

    @Override
    public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> @NonNull V doMidstreamProcessingForLightweightAssetValue(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject, @NonNull V value) throws Exception {
        return value;
    }

    @Override
    public void process(TraceStateSnapshot currentState) {
        GlProgramAsset programAsset = (GlProgramAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC).get(this.programId);
        if (programAsset != null) {
            this.doMidstreamProcessingForAsset(currentState, programAsset);
        } else assert (false);
    }
}

