/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ImageAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ScreenshotAttachment
extends ImageAttachment
implements IImageProvider {
    private static final long serialVersionUID = 1612017060076812994L;

    public ScreenshotAttachment(@NonNull AbstractConstantOrAliasSpecExtended format, @NonNull AbstractConstantOrAliasSpecExtended type, @NonNull Dimension size, @Nullable IByteDataProvider data) throws TraceParseException {
        super(format, type, size, data);
        if (data == null) {
            throw new TraceParseException("No data attached to ScreenshotAttachment of format " + format + " and size " + size);
        }
        if (!size.is2D()) {
            throw new TraceParseException("Screenshot size is not 2D.");
        }
        int expectedLength = 4 * size.getArea();
        if (data.getLength() != expectedLength) {
            throw new TraceParseException("Screenshot size is " + size + "but data was " + data.getLength() + " bytes. Expected " + expectedLength + " bytes.");
        }
    }

    @Override
    public @NonNull IByteDataProvider getData() {
        return (IByteDataProvider)NullUtils.neverNull((Object)super.getData());
    }

    @Override
    public void process(TraceStateSnapshot currentState) {
        FunctionCall functionCall = this.getParentFunctionCall();
        ((Frame)NullUtils.neverNull((Object)functionCall.getParentFrame())).setScreenshot(this);
    }

    @Override
    public @NonNull RGBAImageData getImageData() {
        try {
            return new RGBAImageData(this.size, this.getData(), RGBAImageData.CoordinateOrigin.TOP_LEFT);
        }
        catch (IImageProvider.ImageConversionException e) {
            throw new AssertionError((Object)e);
        }
    }
}

