/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.util.CollectionUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;

public class ProgramResourceDescriptorMap
implements Serializable {
    private static final long serialVersionUID = -7467827929821968270L;
    private final Map<AbstractConstantOrAliasSpecExtended, Map<Long, ProgramResourceDescriptor>> resourcesMap;

    public static @NonNull ProgramResourceDescriptorMap createFromList(@NonNull List<@NonNull ProgramResourceDescriptor> resourcesList) {
        HashMap<AbstractConstantOrAliasSpecExtended, Map<Long, ProgramResourceDescriptor>> resourceMap = new HashMap<AbstractConstantOrAliasSpecExtended, Map<Long, ProgramResourceDescriptor>>();
        for (ProgramResourceDescriptor resourceDesriptor : resourcesList) {
            if (!resourceMap.containsKey(resourceDesriptor.getResourceType())) {
                resourceMap.put(resourceDesriptor.getResourceType(), new TreeMap());
            }
            ((Map)NullUtils.neverNull((Object)((Map)resourceMap.get(resourceDesriptor.getResourceType())))).put(resourceDesriptor.getIndex(), resourceDesriptor);
        }
        return new ProgramResourceDescriptorMap(resourceMap);
    }

    public ProgramResourceDescriptorMap() {
        this.resourcesMap = Collections.EMPTY_MAP;
    }

    public ProgramResourceDescriptorMap(Map<AbstractConstantOrAliasSpecExtended, Map<Long, ProgramResourceDescriptor>> resourcesMap) {
        this.resourcesMap = CollectionUtils.unmodifiableMapOfMaps(resourcesMap);
    }

    public Set<@NonNull AbstractConstantOrAliasSpecExtended> getAvailableResourceTypes() {
        return this.resourcesMap.keySet();
    }

    public @NonNull Map<@NonNull Long, ProgramResourceDescriptor> getResourcesMap(@NonNull AbstractConstantOrAliasSpecExtended resourceType) {
        Map result = this.resourcesMap.get(resourceType);
        return result != null ? result : Collections.EMPTY_MAP;
    }

    public boolean isEmpty() {
        return this.resourcesMap.isEmpty();
    }

    public @NonNull List<@NonNull ProgramResourceDescriptor> getProgramResourcesList() {
        ArrayList<@NonNull ProgramResourceDescriptor> result = new ArrayList<ProgramResourceDescriptor>();
        for (AbstractConstantOrAliasSpecExtended type : this.getAvailableResourceTypes()) {
            Map<@NonNull Long, ProgramResourceDescriptor> byType = this.getResourcesMap(type);
            for (ProgramResourceDescriptor prd : byType.values()) {
                result.add((ProgramResourceDescriptor)NullUtils.neverNull((Object)prd));
            }
        }
        result.sort(new Comparator<ProgramResourceDescriptor>(){

            @Override
            public int compare(@NonNull ProgramResourceDescriptor o1, @NonNull ProgramResourceDescriptor o2) {
                int typeComparison = o1.getResourceType().compareTo(o2.getResourceType());
                if (typeComparison != 0) {
                    return typeComparison;
                }
                return Long.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return result;
    }
}

