/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public final class ProgramResourceDescriptor
implements Serializable {
    private static final long serialVersionUID = -7502462092912563758L;
    private final @NonNull Set<Long> activeVariables;
    private final @NonNull List<ProgramResourceAdditionalLocation> additionalLocations;
    private final long index;
    private final @NonNull String name;
    private final long programID;
    private final @NonNull Map<AbstractConstantOrAliasSpecExtended, Integer> properties;
    private final @NonNull AbstractConstantOrAliasSpecExtended resourceType;

    public ProgramResourceDescriptor(@NonNull AbstractConstantOrAliasSpecExtended resourceType, long programID, long index, @NonNull String name, @NonNull Map<AbstractConstantOrAliasSpecExtended, Integer> properties, @NonNull Set<Long> activeVariables, @NonNull List<ProgramResourceAdditionalLocation> additionalLocations) {
        this.resourceType = resourceType;
        this.programID = programID;
        this.index = index;
        this.name = name;
        this.properties = Collections.unmodifiableMap(properties);
        this.activeVariables = Collections.unmodifiableSet(activeVariables);
        this.additionalLocations = Collections.unmodifiableList(additionalLocations);
    }

    public @NonNull Set<Long> getActiveVariables() {
        return this.activeVariables;
    }

    public @NonNull List<ProgramResourceAdditionalLocation> getAdditionalLocations() {
        return this.additionalLocations;
    }

    public long getIndex() {
        return this.index;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getNameWithoutSuffix() {
        return (String)NullUtils.neverNull((Object)(this.name.endsWith("[0]") ? this.name.substring(0, this.name.length() - 3) : this.name));
    }

    public long getProgramID() {
        return this.programID;
    }

    public @NonNull Map<AbstractConstantOrAliasSpecExtended, Integer> getProperties() {
        return this.properties;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getResourceType() {
        return this.resourceType;
    }

    public int resolveArraySize() {
        return this.getProperty(KapiSpec.GLES.constants.GL_ARRAY_SIZE, 0);
    }

    public int resolveArrayStride() {
        return this.getProperty(KapiSpec.GLES.constants.GL_ARRAY_STRIDE, 0);
    }

    public int resolveAtomicCounterBufferIndex() {
        return this.getProperty(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER_INDEX, -1);
    }

    public int resolveBlockIndex() {
        return this.getProperty(KapiSpec.GLES.constants.GL_BLOCK_INDEX, -1);
    }

    public int resolveBufferBinding() {
        return this.getProperty(KapiSpec.GLES.constants.GL_BUFFER_BINDING, 0);
    }

    public long resolveBufferDataSize() {
        return this.getProperty(KapiSpec.GLES.constants.GL_BUFFER_DATA_SIZE, 0);
    }

    public int resolveElementLength() {
        AbstractConstantOrAliasSpecExtended type = this.resolveType();
        return Math.max(1, type.getNumberOfRowsAsInt() * type.getNumberOfColumnsAsInt());
    }

    public boolean resolveIsReferencedByComputeShader() {
        return this.getProperty(KapiSpec.GLES.constants.GL_REFERENCED_BY_COMPUTE_SHADER, 0) != 0;
    }

    public boolean resolveIsReferencedByFragmentShader() {
        return this.getProperty(KapiSpec.GLES.constants.GL_REFERENCED_BY_FRAGMENT_SHADER, 0) != 0;
    }

    public boolean resolveIsReferencedByVertexShader() {
        return this.getProperty(KapiSpec.GLES.constants.GL_REFERENCED_BY_VERTEX_SHADER, 0) != 0;
    }

    public boolean resolveIsRowMajor() {
        return this.getProperty(KapiSpec.GLES.constants.GL_IS_ROW_MAJOR, 0) != 0;
    }

    public int resolveLocation() {
        return this.getProperty(KapiSpec.GLES.constants.GL_LOCATION, -1);
    }

    public int resolveMatrixStride() {
        return this.getProperty(KapiSpec.GLES.constants.GL_MATRIX_STRIDE, -1);
    }

    public long resolveOffset() {
        return this.getProperty(KapiSpec.GLES.constants.GL_OFFSET, -1);
    }

    public int resolveTopLevelArraySize() {
        return this.getProperty(KapiSpec.GLES.constants.GL_TOP_LEVEL_ARRAY_SIZE, 0);
    }

    public int resolveTopLevelArrayStride() {
        return this.getProperty(KapiSpec.GLES.constants.GL_TOP_LEVEL_ARRAY_STRIDE, 0);
    }

    public @NonNull AbstractConstantOrAliasSpecExtended resolveType() {
        AbstractConstantOrAliasSpecExtended resultOther;
        Long value = this.getProperty(KapiSpec.GLES.constants.GL_TYPE, 0);
        AbstractConstantOrAliasSpecExtended result = KapiSpec.GLES.constantGroups.GLGETACTIVEUNIFORM_TYPE.getConstantSpecByValue(value);
        if (result.isAnonymous() && (resultOther = KapiSpec.GLES.getConstantSpecByValue(value)) != null) {
            return resultOther;
        }
        return result;
    }

    private int getProperty(AbstractConstantOrAliasSpecExtended key, int dflt) {
        Integer result = this.properties.get(key);
        return result != null ? result : dflt;
    }

    public static final class ProgramResourceAdditionalLocation
    implements Serializable {
        private static final long serialVersionUID = 858049043523404218L;
        private final int location;
        private final @NonNull String name;

        public ProgramResourceAdditionalLocation(@NonNull String name, int location) {
            this.name = name;
            this.location = location;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ProgramResourceAdditionalLocation)) {
                return false;
            }
            ProgramResourceAdditionalLocation that = (ProgramResourceAdditionalLocation)obj;
            return this.name.equals(that.name) && this.location == that.location;
        }

        public int getLocation() {
            return this.location;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.location;
        }
    }
}

