/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public final class ProgramGeometryShaderProperties
implements Serializable {
    private static final long serialVersionUID = -262549431230170244L;
    private final @NonNull AbstractConstantOrAliasSpecExtended inputType;
    private final @NonNull AbstractConstantOrAliasSpecExtended outputType;
    private final int shaderInvocations;
    private final int verticesOut;

    public static long calculateNumberOfPrimitivesFromNumberOfVertices(@NonNull AbstractConstantOrAliasSpecExtended type, long vertices) {
        if (KapiSpec.GLES.constants.GL_FALSE.equals(type) || KapiSpec.GLES.constants.GL_POINTS.equals(type)) {
            return vertices > 0L ? vertices : 0L;
        }
        if (KapiSpec.GLES.constants.GL_LINES.equals(type) || KapiSpec.GLES.constants.GL_LINES_ADJACENCY.equals(type)) {
            return vertices > 1L ? vertices / 2L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_LINE_STRIP.equals(type) || KapiSpec.GLES.constants.GL_LINE_STRIP_ADJACENCY.equals(type)) {
            return vertices > 1L ? vertices - 1L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_LINE_LOOP.equals(type)) {
            return vertices > 1L ? vertices : 0L;
        }
        if (KapiSpec.GLES.constants.GL_TRIANGLES.equals(type) || KapiSpec.GLES.constants.GL_TRIANGLES_ADJACENCY.equals(type)) {
            return vertices > 2L ? vertices / 3L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_TRIANGLE_STRIP.equals(type) || KapiSpec.GLES.constants.GL_TRIANGLE_STRIP_ADJACENCY.equals(type)) {
            return vertices > 2L ? vertices - 2L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_TRIANGLE_FAN.equals(type)) {
            return vertices > 2L ? vertices - 2L : 0L;
        }
        return 0L;
    }

    public static long calculateNumberOfVerticesFromNumberOfPrimitives(@NonNull AbstractConstantOrAliasSpecExtended type, long primitives) {
        if (KapiSpec.GLES.constants.GL_FALSE.equals(type) || KapiSpec.GLES.constants.GL_POINTS.equals(type)) {
            return primitives > 0L ? primitives : 0L;
        }
        if (KapiSpec.GLES.constants.GL_LINES.equals(type) || KapiSpec.GLES.constants.GL_LINES_ADJACENCY.equals(type)) {
            return primitives > 0L ? primitives * 2L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_LINE_STRIP.equals(type) || KapiSpec.GLES.constants.GL_LINE_STRIP_ADJACENCY.equals(type)) {
            return primitives > 0L ? primitives + 1L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_LINE_LOOP.equals(type)) {
            return primitives > 0L ? primitives : 0L;
        }
        if (KapiSpec.GLES.constants.GL_TRIANGLES.equals(type) || KapiSpec.GLES.constants.GL_TRIANGLES_ADJACENCY.equals(type)) {
            return primitives > 0L ? primitives * 3L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_TRIANGLE_STRIP.equals(type) || KapiSpec.GLES.constants.GL_TRIANGLE_STRIP_ADJACENCY.equals(type)) {
            return primitives > 0L ? primitives + 2L : 0L;
        }
        if (KapiSpec.GLES.constants.GL_TRIANGLE_FAN.equals(type)) {
            return primitives > 0L ? primitives + 2L : 0L;
        }
        return 0L;
    }

    public ProgramGeometryShaderProperties(@NonNull AbstractConstantOrAliasSpecExtended inputType, @NonNull AbstractConstantOrAliasSpecExtended outputType, int verticesOut, int shaderInvocations) {
        this.inputType = inputType;
        this.outputType = outputType;
        this.verticesOut = verticesOut;
        this.shaderInvocations = shaderInvocations;
    }

    public long calculateInputPrimitives(long numberOfIndices) {
        return ProgramGeometryShaderProperties.calculateNumberOfPrimitivesFromNumberOfVertices(this.inputType, numberOfIndices);
    }

    public long calculateNumberOfOutputPrimitives(long numberOfIndices) {
        long inputPrimitives = this.calculateInputPrimitives(numberOfIndices);
        long primitivesOut = this.getNumberOfOutputPrimitivesForSingleExecution();
        return inputPrimitives * primitivesOut * (long)this.shaderInvocations;
    }

    public long calculateNumberOfOutputVertices(long numberOfIndices) {
        return ProgramGeometryShaderProperties.calculateNumberOfVerticesFromNumberOfPrimitives(this.outputType, this.calculateNumberOfOutputPrimitives(numberOfIndices));
    }

    public AbstractConstantOrAliasSpecExtended getInputType() {
        return this.inputType;
    }

    public long getNumberOfOutputPrimitivesForSingleExecution() {
        return ProgramGeometryShaderProperties.calculateNumberOfPrimitivesFromNumberOfVertices(this.outputType, this.verticesOut);
    }

    public AbstractConstantOrAliasSpecExtended getOutputType() {
        return this.outputType;
    }

    public int getShaderInvocations() {
        return this.shaderInvocations;
    }

    public int getVerticesOut() {
        return this.verticesOut;
    }
}

