/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.ArrayArgumentAttachment;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ObjectArrayArgumentAttachment<T>
extends ArrayArgumentAttachment<T> {
    private static final long serialVersionUID = 964307410382945079L;
    private final @NonNull List<@NonNull T> values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectArrayArgumentAttachment(@NonNull List<@NonNull T> values, @NonNull WeakHashMap<@NonNull List<@NonNull T>, @Nullable WeakReference<@NonNull List<@NonNull T>>> valuesCache) {
        List cachedList;
        if (values.size() == 0) {
            cachedList = NullUtils.EMPTY_LIST;
        } else {
            WeakHashMap<List<T>, WeakReference<List<T>>> weakHashMap = valuesCache;
            synchronized (weakHashMap) {
                WeakReference<@NonNull List<@NonNull T>> cachedListRef = valuesCache.get(values);
                List list = cachedList = cachedListRef == null ? null : (List)cachedListRef.get();
                if (cachedList == null) {
                    cachedList = NullUtils.unmodifiableList(new ArrayList<T>(values));
                    valuesCache.put(cachedList, new WeakReference<List>(cachedList));
                }
            }
        }
        this.values = cachedList;
    }

    @Override
    public @NonNull List<@NonNull T> asList() {
        return this.values;
    }

    @Override
    public @NonNull T get(int index) {
        return this.values.get(index);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Iterator<@NonNull T> iterator() {
        return this.values.iterator();
    }

    public final int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ObjectArrayArgumentAttachment) {
            ObjectArrayArgumentAttachment other = (ObjectArrayArgumentAttachment)obj;
            return this.values.equals(other.values);
        }
        return false;
    }
}

