/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IFunctionCallDataStore;
import com.arm.mgd.core.util.ReadOnlySubList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class MemoryDataStore
implements IFunctionCallDataStore {
    private final @NonNull List<@NonNull FunctionCall> callList = new ArrayList<FunctionCall>();

    @Override
    public FunctionCall get(int index) {
        assert (index <= this.callList.size());
        return this.callList.get(index);
    }

    @Override
    public @NonNull List<@NonNull FunctionCall> get(int index, int length) {
        if (index < 0 || length < 0 || index + length > this.callList.size()) {
            throw new IndexOutOfBoundsException("Invalid index or length (" + index + ", " + length + ") in MemoryDataStore");
        }
        return new ReadOnlySubList<FunctionCall>(this.callList, index, index + length);
    }

    @Override
    public int count() {
        return this.callList.size();
    }

    @Override
    public void add(FunctionCall fcToAdd) {
        this.callList.add(fcToAdd);
    }

    public @NonNull List<@NonNull FunctionCall> getFunctions() {
        return Collections.unmodifiableList(this.callList);
    }
}

