/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.utils.NullUtils;

public class MappingAttachment
extends AbstractFreeAttachment {
    private static final long serialVersionUID = -6133069607417459526L;
    private final long mappingId;

    public MappingAttachment(long mappingId) {
        this.mappingId = mappingId;
    }

    @Override
    public void process(TraceStateSnapshot currentState) {
        ProgramOverride po;
        Long mappingIdObject;
        FunctionCall functionCall = this.getParentFunctionCall();
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLCREATEPROGRAM)) {
            Long programId = GLES.GlCreateProgramDecorator.getReturnValue(functionCall);
            mappingIdObject = this.mappingId;
            for (AbstractFrameOverride afo : ((Frame)NullUtils.neverNull((Object)functionCall.getParentFrame())).getFrameOverrides()) {
                if (!(afo instanceof ProgramOverride) || (po = (ProgramOverride)afo).getOverrideProgram() == null || !po.getOverrideProgram().equals(mappingIdObject)) continue;
                po.setProgramMappingId(programId);
            }
        }
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLCREATESHADER)) {
            Long shaderId = GLES.GlCreateShaderDecorator.getReturnValue(functionCall);
            mappingIdObject = this.mappingId;
            for (AbstractFrameOverride afo : ((Frame)NullUtils.neverNull((Object)functionCall.getParentFrame())).getFrameOverrides()) {
                if (!(afo instanceof ProgramOverride)) continue;
                po = (ProgramOverride)afo;
                if (po.getOverrideFragmentShaderID() != null && po.getOverrideFragmentShaderID().equals(mappingIdObject)) {
                    po.setFragmentMappingId(shaderId);
                    continue;
                }
                if (po.getOverrideVertexShaderID() == null || !po.getOverrideVertexShaderID().equals(mappingIdObject)) continue;
                po.setVertexMappingId(shaderId);
            }
        }
    }

    public long getMappingId() {
        return this.mappingId;
    }
}

