/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.EglAttribAssetProcessor;
import com.arm.mgd.core.asset.LongsArgAttachmentProcessor;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractLongsArgAttachment;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.FunctionSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.BasicTypeRefSpec;
import com.arm.mgd.kapi.gen.DisplayEnum;
import com.arm.mgd.kapi.gen.FormatSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LongsArgAttachment
extends AbstractLongsArgAttachment<Long> {
    private static final long serialVersionUID = -2546073138299617923L;

    public static @NonNull LongsArgAttachment create(List<Long> longsList) {
        assert (longsList != null);
        assert (NullUtils.isCollectionNonNull(longsList));
        return new LongsArgAttachment(longsList);
    }

    public LongsArgAttachment(@NonNull List<@NonNull Long> longsList) {
        super(longsList);
    }

    @Override
    public @NonNull Long get(int index) {
        return NullUtils.longValueOf((long)this.getLong(index));
    }

    @Override
    public long getLong(int index) {
        return super.getLong(index);
    }

    public PrimitiveIterator.OfLong iterator() {
        return this.primitiveIterator();
    }

    @Override
    public @NonNull List<@NonNull Long> asList() {
        return this.asLongsList();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LongsArgAttachment) {
            return super.equals(obj);
        }
        return false;
    }

    public @NonNull List<@NonNull String> toStrings() {
        if (this.isNull()) {
            return NullUtils.EMPTY_LIST;
        }
        List<@NonNull String> strings = null;
        @NonNull ArgumentSpec argumentSpec = this.getArgumentSpec();
        @Nullable FormatSpec formatSpec = argumentSpec.getFormat();
        @Nullable FunctionSpec functionSpec = argumentSpec.getParentFunctionSpec();
        @Nullable UsageSpec usageSpec = argumentSpec.getUsage();
        if (usageSpec != null && usageSpec.getEglAttributeList() != null) {
            strings = EglAttribAssetProcessor.attributesToStrings(this);
        } else if (formatSpec != null && formatSpec.getArray() != null && functionSpec != null) {
            LongsArgAttachmentProcessor processor = new LongsArgAttachmentProcessor((KapiSpec)NullUtils.neverNull((Object)functionSpec.getKapiSpec()), (DisplayEnum)((Object)NullUtils.neverNull((Object)((Object)formatSpec.getArray().getBasicTypeRef().getValue().getDisplay()))), argumentSpec.getUsage());
            strings = new ArrayList<String>(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                strings.add((String)NullUtils.neverNull((Object)processor.valueToString(NullUtils.longValueOf((long)l))));
            }
        }
        if (strings == null) {
            strings = new ArrayList<String>(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                strings.add((String)NullUtils.neverNull((Object)String.format("0x%s", Long.toHexString(l))));
            }
        }
        return strings;
    }

    @Override
    public @NonNull String getDescriptiveText() {
        if (this.isNull()) {
            return "NULL";
        }
        return (String)NullUtils.neverNull((Object)Arrays.toString(this.toStrings().toArray()));
    }

    @Override
    public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
        if (this.isNull()) {
            return ArgumentHierarchyLeaf.nullPointer(this.getArgumentName());
        }
        List<@NonNull String> strings = this.toStrings();
        ArgumentHierarchyLeaf.LeafType type = this.getType();
        ArrayList<@NonNull ArgumentHierarchyNode> elementList = new ArrayList<ArgumentHierarchyNode>(strings.size());
        for (String string : strings) {
            elementList.add(new ArgumentHierarchyLeaf((String)NullUtils.neverNull((Object)string), type));
        }
        return ArgumentHierarchyBranch.arrayHierarchy(this.getArgumentName(), elementList);
    }

    private @NonNull ArgumentHierarchyLeaf.LeafType getType() {
        @NonNull ArgumentSpec argumentSpec = this.getArgumentSpec();
        @Nullable FormatSpec formatSpec = argumentSpec.getFormat();
        @Nullable UsageSpec usageSpec = argumentSpec.getUsage();
        if (usageSpec != null && usageSpec.getEglAttributeList() != null) {
            return ArgumentHierarchyLeaf.LeafType.ENUM;
        }
        if (formatSpec != null && formatSpec.getArray() != null) {
            BasicTypeRefSpec basicType = formatSpec.getArray().getBasicTypeRef();
            assert (basicType != null);
            switch (basicType.getValue().getDisplay()) {
                case CONSTANT: {
                    return ArgumentHierarchyLeaf.LeafType.ENUM;
                }
                case HEX: {
                    return ArgumentHierarchyLeaf.LeafType.POINTER;
                }
            }
        }
        return ArgumentHierarchyLeaf.LeafType.INTEGER;
    }
}

