/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.LongsArgAttachmentProcessor;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractArgumentAttachment;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.FunctionSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.BasicTypeRefSpec;
import com.arm.mgd.kapi.gen.DisplayEnum;
import com.arm.mgd.kapi.gen.ElementTypeSpec;
import com.arm.mgd.kapi.gen.FormatSpec;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LongPtrArgAttachment
extends AbstractArgumentAttachment {
    private static final long serialVersionUID = -538392045360564629L;
    public final long value;

    public LongPtrArgAttachment(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public @NonNull String getDescriptiveText() {
        if (this.isNull()) {
            return "NULL";
        }
        @NonNull ArgumentSpec argumentSpec = this.getArgumentSpec();
        @Nullable UsageSpec usageSpec = argumentSpec.getUsage();
        @Nullable FormatSpec formatSpec = argumentSpec.getFormat();
        @Nullable FunctionSpec functionSpec = argumentSpec.getParentFunctionSpec();
        String argText = null;
        if (usageSpec != null && !usageSpec.isBitfield()) {
            argText = usageSpec.getConstantSpecByValue(NullUtils.longValueOf((long)this.getValue())).toString();
        } else if (formatSpec != null && formatSpec.getScalar() != null && formatSpec.getScalar().getBasicTypeRef() != null && formatSpec.getScalar().getBasicTypeRef().getValue().getJtype() == ElementTypeSpec.POINTER && functionSpec != null) {
            LongsArgAttachmentProcessor processor = new LongsArgAttachmentProcessor((KapiSpec)NullUtils.neverNull((Object)functionSpec.getKapiSpec()), (DisplayEnum)((Object)NullUtils.neverNull((Object)((Object)formatSpec.getScalar().getBasicTypeRef().getValue().getDisplay()))), usageSpec);
            argText = processor.valueToString(NullUtils.longValueOf((long)this.getValue()));
        }
        if (argText == null) {
            argText = (String)NullUtils.neverNull((Object)Long.toString(this.getValue()));
        }
        return argText;
    }

    @Override
    public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
        if (this.isNull()) {
            return ArgumentHierarchyLeaf.nullPointer(this.getArgumentName());
        }
        return new ArgumentHierarchyLeaf(this.getArgumentName(), this.getDescriptiveText(), this.getType());
    }

    private @NonNull ArgumentHierarchyLeaf.LeafType getType() {
        @NonNull ArgumentSpec argumentSpec = this.getArgumentSpec();
        @Nullable UsageSpec usageSpec = argumentSpec.getUsage();
        @Nullable FormatSpec formatSpec = argumentSpec.getFormat();
        if (usageSpec != null) {
            return ArgumentHierarchyLeaf.LeafType.ENUM;
        }
        if (formatSpec != null && formatSpec.getScalar() != null) {
            BasicTypeRefSpec basicType = formatSpec.getScalar().getBasicTypeRef();
            assert (basicType != null);
            switch (basicType.getValue().getDisplay()) {
                case CONSTANT: {
                    return ArgumentHierarchyLeaf.LeafType.ENUM;
                }
                case HEX: {
                    return ArgumentHierarchyLeaf.LeafType.POINTER;
                }
            }
        }
        return ArgumentHierarchyLeaf.LeafType.INTEGER;
    }
}

