/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.InterestingCallData;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.Statistic;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InterestingFunctionCall
extends FunctionCall {
    private static final long serialVersionUID = -7990936725081511413L;
    private @Nullable InterestingCallData interestingCallData;

    public InterestingFunctionCall(int index, @NonNull FunctionCallDescriptor functionCallDescriptor, @NonNull TraceDataModel model) {
        super(index, functionCallDescriptor, model);
        assert (functionCallDescriptor.getFunctionSpec().isInterestingCall());
    }

    public void setInterestingCallData(@NonNull InterestingCallData data) {
        assert (this.interestingCallData == null);
        this.interestingCallData = data;
    }

    public boolean hasInterestingCallData() {
        return this.interestingCallData != null;
    }

    @Override
    public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
        return this.getInterestingCallData().getStatistic(type);
    }

    @Override
    public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
        return this.getInterestingCallData().hasDataForStatisticType(type);
    }

    public @NonNull InterestingCallData getInterestingCallData() {
        if (this.interestingCallData == null && this.hasError()) {
            this.interestingCallData = new InterestingCallData(){
                private static final long serialVersionUID = -2853828605158400241L;

                @Override
                public @NonNull String getDescriptiveText() {
                    return "Error: " + InterestingFunctionCall.this.getErrorCodeAsString();
                }
            };
        }
        if (this.interestingCallData != null) {
            return this.interestingCallData;
        }
        throw new RuntimeException("Interesting call has no data.");
    }
}

