/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IMemoryRegionAttachment
extends Serializable {
    public long getOffset();

    public int getSize();

    public @Nullable IByteDataProvider getDataForRegion();

    default public void copyIntoByteArray(long offset, byte @NonNull [] dstData) {
        @Nullable IByteDataProvider dataProvider = this.getDataForRegion();
        if (dataProvider != null) {
            int size = dstData.length;
            long attStart = this.getOffset();
            long attEnd = attStart + (long)this.getSize();
            long memStart = offset;
            long memEnd = memStart + (long)size;
            @Nullable ByteBuffer data = dataProvider.getData();
            if (attStart < memEnd && memStart < attEnd) {
                int attachmentOffset = (int)(attStart < memStart ? memStart - attStart : 0L);
                int bufferOffset = (int)(attStart > memStart ? attStart - memStart : 0L);
                int bytesToCopy = Math.min(data.remaining() - attachmentOffset, size - bufferOffset);
                data.position(attachmentOffset);
                data.get(dstData, bufferOffset, bytesToCopy);
            }
        }
    }
}

