/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IFunctionCallRangeItem;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

final class FunctionCallRange
implements IFunctionCallRangeItem,
Serializable {
    private static final long serialVersionUID = -2995764357924105807L;
    private final int fromIndex;
    private int toIndex;

    public FunctionCallRange(int fromIndex, int toIndex) {
        assert (fromIndex <= toIndex);
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    public boolean canBeExtendedBy(@NonNull FunctionCall functionCall) {
        return this.toIndex + 1 == functionCall.getIndex();
    }

    @Override
    public int compareContains(@NonNull FunctionCall functionCall) {
        if (this.fromIndex > functionCall.getIndex()) {
            return 1;
        }
        if (this.toIndex < functionCall.getIndex()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getFirstFunctionIndex() {
        return this.fromIndex;
    }

    @Override
    public int getLastFunctionCallIndex() {
        return this.toIndex;
    }

    @Override
    public boolean isBefore(@NonNull FunctionCall functionCall) {
        return this.toIndex < functionCall.getIndex();
    }

    @Override
    public @NonNull IFunctionCallRangeItem replaceByExtension(@NonNull FunctionCall functionCall) {
        assert (this.canBeExtendedBy(functionCall));
        this.toIndex = functionCall.getIndex();
        return this;
    }

    public String toString() {
        return String.format("[%s, %s]", String.valueOf(this.fromIndex), String.valueOf(this.toIndex));
    }
}

