/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.diff.IDiffable;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.SerializableDependency;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.AbstractOverrideAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerHelper;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyFactory;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.ClEnqueueCall;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameFeaturesFlagsEnum;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.data.IArgumentParent;
import com.arm.mgd.core.target.data.ITraceItem;
import com.arm.mgd.core.target.data.InterestingFunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.core.util.Neighbours;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.ElementTypeSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCall
implements INavigationElement<FunctionCall>,
SerializableDependency,
IDiffable<FunctionCall>,
ITraceItem,
IArgumentParent {
    private static final long serialVersionUID = 8707749327070172217L;
    private final int index;
    private final Serializable[] argValues;
    private final int pid;
    private final long tid;
    private final long timestampStart;
    private final long timestampStop;
    private final @NonNull IFunctionOrAliasSpecExtended functionSpec;
    private final @Nullable Serializable returnValue;
    private @Nullable Frame parentFrame;
    private @NonNull List<@NonNull AbstractFreeAttachment> freeAttachments;
    private final int errorCode;
    private boolean frameEnd = false;
    private boolean hidden = false;
    private final boolean missingFunctionCalled;
    private final @NonNull Set<@NonNull FrameFeaturesFlagsEnum> featuresEnabled;
    private final @NonNull List<@NonNull AbstractOverrideAttachment> frameOverrides;
    private boolean cachedHasMidstreamTraceData = false;
    private final @Nullable Integer asynchronousFunctionCallUid;
    private final @NonNull TraceDataModel model;

    @Override
    public Object writeReplace() {
        return new SerializationProxy(this);
    }

    @Override
    public int getLabelIndex() {
        return this.getIndex();
    }

    public FunctionCall(int index, @NonNull FunctionCallDescriptor functionCallDescriptor, @NonNull TraceDataModel model) {
        this.index = index;
        this.pid = functionCallDescriptor.getProcessId();
        this.tid = functionCallDescriptor.getThreadId();
        this.functionSpec = functionCallDescriptor.getFunctionSpec();
        this.timestampStart = functionCallDescriptor.getTimestampStart().asLong();
        this.timestampStop = functionCallDescriptor.getTimestampStop().asLong();
        this.errorCode = this.initErrorCode(functionCallDescriptor.getErrorCode());
        this.returnValue = functionCallDescriptor.getReturnValue();
        this.frameEnd = this.functionSpec.isAlwaysFrameEnd() || functionCallDescriptor.isFrameEnd();
        this.hidden = functionCallDescriptor.isHidden();
        this.argValues = functionCallDescriptor.getArgumentsAsArray(this);
        this.missingFunctionCalled = functionCallDescriptor.isMissingFunctionCalled();
        @NonNull List<@NonNull AbstractFreeAttachment> freeAttachmentsList = functionCallDescriptor.getFreeAttachments(this);
        this.freeAttachments = freeAttachmentsList.size() == 0 ? NullUtils.EMPTY_LIST : freeAttachmentsList;
        this.cachedHasMidstreamTraceData = this.findFreeAttachment(MidstreamDataAttachment.class) != null;
        this.asynchronousFunctionCallUid = functionCallDescriptor.getAsynchronousFunctionCallUid();
        @NonNull Set<@NonNull FrameFeaturesFlagsEnum> enabledFeaturesSet = functionCallDescriptor.getFeaturesEnabled();
        this.featuresEnabled = enabledFeaturesSet.size() == 0 ? NullUtils.EMPTY_SET : (Set)NullUtils.neverNull(EnumSet.copyOf(enabledFeaturesSet));
        @NonNull List<@NonNull AbstractOverrideAttachment> frameOverridesList = functionCallDescriptor.getFrameOverrides();
        this.frameOverrides = frameOverridesList.size() == 0 ? NullUtils.EMPTY_LIST : frameOverridesList;
        this.model = model;
        assert (this.timestampStart <= this.timestampStop) : "Timestamps out of order: " + this.timestampStart + " <= " + this.timestampStop;
    }

    private int initErrorCode(Integer errorCode2) {
        if (errorCode2 != null) {
            return errorCode2;
        }
        return this.functionSpec.isUnrecognisedFunction() ? 0 : this.functionSpec.getKapiSpec().getSuccessConstant().getResolvedValue().intValue();
    }

    @Deprecated
    public static Serializable convertArgStringToJavaType(Serializable inputValue, ElementTypeSpec elementType, UsageSpec usage) {
        if (inputValue == null || elementType == null) {
            return inputValue;
        }
        try {
            Comparable<Long> outputValue = null;
            @NonNull String inputString = (String)NullUtils.neverNull((Object)inputValue.toString());
            switch (elementType) {
                case INTEGER: {
                    Integer intVal = NumberUtils.decodeInt(inputString);
                    outputValue = intVal;
                    if (usage == null || usage.isBitfield()) break;
                    outputValue = usage.getConstantSpecByValue(NullUtils.longValueOf((long)intVal.longValue()));
                    break;
                }
                case LONG: 
                case HANDLE: {
                    outputValue = NumberUtils.decodeLong(inputString);
                    if (usage == null || usage.isBitfield()) break;
                    outputValue = usage.getConstantSpecByValue((Long)outputValue);
                    break;
                }
                case FLOAT: {
                    outputValue = Float.valueOf(NumberUtils.decodeFloat(inputString));
                    break;
                }
                case DOUBLE: {
                    outputValue = NumberUtils.decodeDouble(inputString);
                    break;
                }
                case POINTER: {
                    outputValue = Pointer.valueOf(NumberUtils.decodeLong(inputString));
                    break;
                }
                case BOOLEAN: {
                    outputValue = Boolean.valueOf(inputString);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return outputValue;
        }
        catch (Throwable t) {
            t.printStackTrace();
            assert (false);
            return inputValue;
        }
    }

    public int getPid() {
        return this.pid;
    }

    public long getTid() {
        return this.tid;
    }

    public Iterable<Serializable> getArgValues() {
        if (this.argValues != null) {
            return Arrays.asList(this.argValues);
        }
        return Collections.emptyList();
    }

    public @NonNull Serializable getArgValue(int i) {
        assert (this.argValues != null);
        return (Serializable)NullUtils.neverNull((Object)this.argValues[i]);
    }

    @Override
    public @NonNull IArgument getArgument(int argIndex) {
        return this.getSerializableArgValueAsIArgument(this.getArgValue(argIndex), argIndex);
    }

    @Override
    public @NonNull List<@NonNull IArgument> getArguments() {
        if (this.argValues != null) {
            ArrayList<@NonNull IArgument> argList = new ArrayList<IArgument>(this.argValues.length);
            int i = 0;
            while (i < this.argValues.length) {
                argList.add(this.getSerializableArgValueAsIArgument((Serializable)NullUtils.neverNull((Object)this.argValues[i]), i));
                ++i;
            }
            return NullUtils.unmodifiableList(argList);
        }
        return NullUtils.emptyList();
    }

    @Override
    public @NonNull ArgumentSpec getChildArgumentSpec(int argId) {
        return (ArgumentSpec)NullUtils.neverNull((Object)this.functionSpec.getArg().get(argId));
    }

    public Serializable getReturnValue() {
        return this.returnValue;
    }

    @Deprecated
    public void addArgAttachment(int argIndex, IArgumentAttachment argAttachment) throws TraceParseException {
        if (this.argValues == null || argIndex >= this.argValues.length || argIndex < 0) {
            throw new TraceParseException(this + ": Argument index " + argIndex + " out of range.");
        }
        ArgumentSpec argumentSpec = this.getFunctionSpec().getArg().get(argIndex);
        assert (argAttachment != null);
        assert (argumentSpec != null);
        ArgumentContainerHelper.setTypeIfContainer(argAttachment, argumentSpec);
        if (this.argValues[argIndex] instanceof IArgumentAttachment) {
            IArgumentAttachment oldValue = (IArgumentAttachment)this.argValues[argIndex];
            assert (argAttachment.getClass() == oldValue.getClass());
            argAttachment.setOriginalPointerValue(oldValue.getOriginalValue());
        } else if (this.argValues[argIndex] instanceof Pointer) {
            argAttachment.setOriginalPointerValue((Pointer)NullUtils.neverNull((Object)((Pointer)this.argValues[argIndex])));
        }
        argAttachment.setParent(this, argIndex);
        this.argValues[argIndex] = argAttachment;
    }

    @Deprecated
    public synchronized void addFreeAttachment(@NonNull AbstractFreeAttachment freeAttachment) {
        if (this.freeAttachments == NullUtils.EMPTY_LIST) {
            this.freeAttachments = new ArrayList<AbstractFreeAttachment>(3);
        }
        this.freeAttachments.add(freeAttachment);
        freeAttachment.setParentFunctionCall(this);
        this.cachedHasMidstreamTraceData |= freeAttachment instanceof MidstreamDataAttachment;
    }

    public String toString() {
        return this.functionSpec.getName();
    }

    public String getErrorCodeAsString() {
        Long errorCodeAsLong = NullUtils.longValueOf((long)this.getErrorCode());
        AbstractConstantOrAliasSpecExtended constantSpec = null;
        if (this.functionSpec.getKapiSpec() == KapiSpec.GLES) {
            constantSpec = KapiSpec.GLES.constantGroups.ERRORCODE.getConstantSpecByValue(errorCodeAsLong);
        } else if (this.functionSpec.getKapiSpec() == KapiSpec.EGL) {
            constantSpec = KapiSpec.EGL.constantGroups.ERRORS_GETERROR_RETURN_VALUES.getConstantSpecByValue(errorCodeAsLong);
        } else if (this.functionSpec.getKapiSpec() == KapiSpec.CL) {
            constantSpec = KapiSpec.CL.constantGroups.ERROR_CODES.getConstantSpecByValue(errorCodeAsLong);
        } else {
            return "N/A";
        }
        return constantSpec.getName();
    }

    public void setParentFrame(@NonNull Frame frame) {
        this.parentFrame = frame;
    }

    public @Nullable Frame getParentFrame() {
        return this.parentFrame;
    }

    @Override
    public @NonNull String getLabelText() {
        return String.valueOf(this.functionSpec.getName()) + " " + this.index;
    }

    @Override
    public @NonNull String getLongLabelText() {
        return this.getLabelText();
    }

    @Override
    public @NonNull String getToolTipText() {
        return this.getLabelText();
    }

    public @NonNull List<@NonNull AbstractFreeAttachment> getFreeAttachments() {
        return NullUtils.unmodifiableList(this.freeAttachments);
    }

    public <T extends AbstractFreeAttachment> @Nullable T findFreeAttachment(Class<T> clazz) {
        for (AbstractFreeAttachment fa : this.getFreeAttachments()) {
            if (!clazz.isAssignableFrom(fa.getClass())) continue;
            return (T)fa;
        }
        return null;
    }

    public <T extends AbstractFreeAttachment> @NonNull List<T> findFreeAttachments(Class<T> clazz) {
        ArrayList<AbstractFreeAttachment> result = new ArrayList<AbstractFreeAttachment>();
        for (AbstractFreeAttachment fa : this.getFreeAttachments()) {
            if (!clazz.isAssignableFrom(fa.getClass())) continue;
            result.add(fa);
        }
        return result;
    }

    public int getFreeAttachmentIndex(@NonNull AbstractFreeAttachment fa) {
        return this.freeAttachments.indexOf(fa);
    }

    public boolean hasError() {
        KapiSpec kapiSpec = this.functionSpec.getKapiSpec();
        if (kapiSpec != null) {
            return kapiSpec.isError(this.getErrorCode());
        }
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public long getTimestampStart() {
        return this.timestampStart;
    }

    public long getTimestampStop() {
        return this.timestampStop;
    }

    public @NonNull IFunctionOrAliasSpecExtended getFunctionSpec() {
        return this.functionSpec;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isFrameEnd() {
        return this.frameEnd;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public @NonNull TraceDataModel getModel() {
        return this.model;
    }

    @Override
    public final Class<FunctionCall> getIDiffableTClass() {
        return FunctionCall.class;
    }

    @Override
    public int compareTo(FunctionCall o) {
        if (o == null) {
            return -1;
        }
        return this.getID().compareTo(o.getID());
    }

    public boolean equals(Object other) {
        if (!(other instanceof FunctionCall)) {
            return false;
        }
        FunctionCall functionCallOther = (FunctionCall)other;
        if (functionCallOther.getModel() != this.getModel()) {
            return false;
        }
        return functionCallOther.getID().equals(this.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public @NonNull FunctionCallID getID() {
        return FunctionCallID.valueOf(this.index);
    }

    public AbstractConstantOrAliasSpecExtended getTextureTarget() {
        if (KapiSpec.GLES.functions.GLTEXIMAGE2D.equals(this.getFunctionSpec())) {
            return GLES.GlTexImage2DDecorator.getArgumentTarget(this);
        }
        if (KapiSpec.GLES.functions.GLTEXSUBIMAGE2D.equals(this.getFunctionSpec())) {
            return GLES.GlTexSubImage2DDecorator.getArgumentTarget(this);
        }
        if (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D.equals(this.getFunctionSpec())) {
            return GLES.GlCompressedTexImage2DDecorator.getArgumentTarget(this);
        }
        if (KapiSpec.GLES.functions.GLCOMPRESSEDTEXSUBIMAGE2D.equals(this.getFunctionSpec())) {
            return GLES.GlCompressedTexSubImage2DDecorator.getArgumentTarget(this);
        }
        return null;
    }

    public boolean isMissingFunctionCalled() {
        return this.missingFunctionCalled;
    }

    @Override
    public @NonNull List<@NonNull FunctionCall> getChildren() {
        return NullUtils.EMPTY_LIST;
    }

    @Override
    public boolean isTheChildrenListFinal() {
        return true;
    }

    public @Nullable FunctionCall getClosestPriorInterestingCallInSameRenderpass() {
        Frame frame = this.getParentFrame();
        if (frame == null) {
            return null;
        }
        FrameRenderPass frp = frame.getRenderPassFor(this);
        FunctionCall currentInterestingCall = null;
        if (this instanceof InterestingFunctionCall) {
            return this;
        }
        if (frp != null) {
            List<InterestingFunctionCall> interestingCalls = frp.getInterestingCalls();
            Neighbours<InterestingFunctionCall> interestingCallNeighbours = BinarySearchList.findNeighbours(interestingCalls, new BinarySearchList.Comparator<InterestingFunctionCall>(){

                @Override
                public int compare(InterestingFunctionCall that) {
                    if (FunctionCall.this.getIndex() < that.getIndex()) {
                        return 1;
                    }
                    if (FunctionCall.this.getIndex() > that.getIndex()) {
                        return -1;
                    }
                    return 0;
                }
            });
            currentInterestingCall = interestingCallNeighbours.getBefore();
        }
        return currentInterestingCall;
    }

    public @NonNull String getFullNameAndArguments() {
        return this.getArgumentHierarchy().printFullHierarchy();
    }

    public static @NonNull FunctionCall create(int index, @NonNull FunctionCallDescriptor functionCallDescriptor, @NonNull TraceDataModel model) {
        if (functionCallDescriptor.getFunctionSpec().isDrawCall()) {
            return new DrawFunctionCall(index, functionCallDescriptor, model);
        }
        if (functionCallDescriptor.getFunctionSpec().isClEnqueueCall()) {
            return new ClEnqueueCall(index, functionCallDescriptor, model);
        }
        if (functionCallDescriptor.getFunctionSpec().isInterestingCall()) {
            return new InterestingFunctionCall(index, functionCallDescriptor, model);
        }
        return new FunctionCall(index, functionCallDescriptor, model);
    }

    public @NonNull Set<@NonNull FrameFeaturesFlagsEnum> getFeaturesEnabled() {
        return this.featuresEnabled;
    }

    public @NonNull List<@NonNull AbstractOverrideAttachment> getFrameOverrides() {
        return this.frameOverrides;
    }

    public boolean hasMidstreamTraceData() {
        return this.cachedHasMidstreamTraceData;
    }

    public long getWaitTime() {
        return this.timestampStop - this.timestampStart;
    }

    public void setFrameEnd() {
        this.frameEnd = true;
    }

    public @NonNull ArgumentHierarchyBranch getArgumentHierarchy() {
        List<IArgument> args = this.getArguments();
        ArrayList<@NonNull ArgumentHierarchyNode> children = new ArrayList<ArgumentHierarchyNode>(args.size());
        for (IArgument arg : args) {
            children.add(arg.getArgumentHierarchy());
        }
        return ArgumentHierarchyBranch.functionHierarchy((String)NullUtils.neverNull((Object)this.functionSpec.getName()), children);
    }

    public @Nullable ArgumentHierarchyNode getReturnHierachy() {
        if (this.returnValue != null) {
            return ArgumentHierarchyFactory.createFromSerializable("return", this.returnValue);
        }
        return null;
    }

    public @Nullable Integer getAsynchronousFunctionCallUid() {
        return this.asynchronousFunctionCallUid;
    }

    private static class SerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = 8436059955695082724L;
        private final int index;
        private final @NonNull TraceDataModel traceDataModel;

        SerializationProxy(FunctionCall functionCall) {
            this.traceDataModel = functionCall.getModel();
            this.index = functionCall.getIndex();
        }

        @Override
        public Object readResolve() {
            return this.traceDataModel.getCallItem(this.index);
        }
    }
}

