/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.ReadOnlySubList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class Frames {
    private final @NonNull List<@NonNull Frame> frameList = new ArrayList<Frame>();
    private Frame latestFrame;
    private boolean nextFrameIsReplayedFrame = false;
    private FrameOverrides overridesEnabledForNextFrame = null;
    private final @NonNull TraceDataModel traceDataModel;
    private boolean frameEndSeen = false;

    Frames(@NonNull TraceDataModel traceDataModel) {
        assert (traceDataModel != null);
        this.traceDataModel = traceDataModel;
    }

    void setFunctionCallFrame(@NonNull FunctionCall fcToAdd) {
        assert (fcToAdd.getParentFrame() == null);
        if (this.latestFrame == null || this.frameEndSeen) {
            this.latestFrame = new Frame(this.traceDataModel, this.frameList.size(), fcToAdd.getIndex(), this.nextFrameIsReplayedFrame);
            this.frameList.add(this.latestFrame);
            if (this.nextFrameIsReplayedFrame) {
                this.nextFrameIsReplayedFrame = false;
                if (this.overridesEnabledForNextFrame != null) {
                    this.latestFrame.setFrameOverrides(this.overridesEnabledForNextFrame);
                    this.overridesEnabledForNextFrame = null;
                }
            } else {
                Frame frameIterator = null;
                int i = this.count() - 1;
                while (i >= 0) {
                    frameIterator = this.getFrameAt(i);
                    if (!frameIterator.isReplayed()) {
                        frameIterator.replayGenericVertexCallCache = null;
                        frameIterator.replayPostFrameStateCache = null;
                        frameIterator.replayPreFrameStateCache = null;
                    }
                    --i;
                }
            }
        }
        assert (this.latestFrame != null);
        fcToAdd.setParentFrame(this.latestFrame);
    }

    void calculateFrameEnd(@NonNull FunctionCall fcToAdd, @NonNull TraceStateSnapshot latestSnapshot) {
        assert (latestSnapshot.getCurrentFunctionCall() == fcToAdd);
        assert (fcToAdd.getParentFrame() == this.latestFrame);
        int lastFunctionIndex = this.latestFrame.incrementLastFunctionIndex(latestSnapshot);
        assert (lastFunctionIndex == fcToAdd.getIndex()) : "Frame function index (" + lastFunctionIndex + ") doesn't match added function call index (" + fcToAdd.getIndex() + ").";
        this.frameEndSeen = fcToAdd.isFrameEnd();
        if (this.frameEndSeen) {
            this.latestFrame.setComplete(true);
        }
    }

    public void setNextFrameIsReplayedFrame(boolean state) {
        this.nextFrameIsReplayedFrame = state;
    }

    public void setNextFrameOverrides(FrameOverrides newOverrides) {
        this.overridesEnabledForNextFrame = newOverrides;
    }

    public FrameOverrides getNextFrameOverrides() {
        return this.overridesEnabledForNextFrame;
    }

    public int count() {
        return this.frameList.size();
    }

    public @NonNull Frame getFrameAt(int index) {
        return this.frameList.get(index);
    }

    public @NonNull List<@NonNull Frame> getFrames() {
        return new ReadOnlySubList<Frame>(this.frameList, 0, this.frameList.size());
    }

    public @NonNull List<@NonNull Frame> getFramesList() {
        return this.frameList;
    }

    public Frame getLatestFrame() {
        return this.latestFrame;
    }

    void onTracingReattachedEvent() {
        if (this.latestFrame != null && this.latestFrame.getApiCallCount() > 0) {
            FunctionCall lastFunction = this.traceDataModel.getCallItem(this.latestFrame.getLastFunctionIndex());
            lastFunction.setFrameEnd();
            this.frameEndSeen |= true;
        }
    }
}

