/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.FrameFeaturesFlagsEnum;
import com.arm.mgd.core.target.data.FunctionCall;
import org.eclipse.jdt.annotation.NonNull;

public class FramebufferFeature {
    public static final @NonNull FramebufferFeature NOTHING = new FramebufferFeature(CaptureMode.NONE, false, false);
    private boolean captureEnabled;
    private boolean replayEnabled;
    private @NonNull CaptureMode captureMode = CaptureMode.NONE;

    public FramebufferFeature(@NonNull CaptureMode currentFeature, boolean captureEnabled, boolean replayEnabled) {
        this.captureEnabled = captureEnabled;
        this.replayEnabled = replayEnabled;
        this.captureMode = currentFeature;
    }

    public boolean isCaptureEnabled() {
        return this.captureEnabled;
    }

    public boolean isReplayEnabled() {
        return this.replayEnabled;
    }

    public @NonNull CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public static @NonNull FramebufferFeature createFramebufferFeatureFromFunctionCall(@NonNull FunctionCall functionCall) {
        CaptureMode captureMode = CaptureMode.NONE;
        boolean captureEnabled = false;
        boolean replayEnabled = false;
        for (FrameFeaturesFlagsEnum feature : functionCall.getFeaturesEnabled()) {
            switch (feature) {
                case OVERDRAW_ENABLED: {
                    captureMode = CaptureMode.OVERDRAW;
                    break;
                }
                case SHADER_MAP_ENABLED: {
                    captureMode = CaptureMode.SHADER_MAP;
                    break;
                }
                case FRAGMENT_COUNT_ENABLED: {
                    captureMode = CaptureMode.FRAGMENT_COUNT;
                    break;
                }
                case CAPTURE_ALL_ATTACHMENTS: {
                    captureMode = CaptureMode.CAPTURE_ALL_ATTACHMENTS;
                    break;
                }
                case FRAME_CAPTURE_ENABLED: {
                    captureEnabled = true;
                    break;
                }
                case FRAME_REPLAY_ENABLED: {
                    replayEnabled = true;
                    break;
                }
            }
        }
        return new FramebufferFeature(captureMode, captureEnabled, replayEnabled);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.captureEnabled ? 1231 : 1237);
        result = 31 * result + this.captureMode.hashCode();
        result = 31 * result + (this.replayEnabled ? 1231 : 1237);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Feature: '").append(this.captureMode.toString()).append("'");
        if (this.captureEnabled) {
            sb.append(" Capture enabled");
        }
        if (this.replayEnabled) {
            sb.append(" Replay enabled");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FramebufferFeature) {
            FramebufferFeature other = (FramebufferFeature)obj;
            return this.captureEnabled == other.captureEnabled && this.captureMode == other.captureMode && this.replayEnabled == other.replayEnabled;
        }
        return false;
    }

    public static final class CaptureMode
    extends Enum<CaptureMode> {
        public static final /* enum */ CaptureMode NONE = new CaptureMode("Colour attachment zero was captured for a render pass of this frame.");
        public static final /* enum */ CaptureMode OVERDRAW = new CaptureMode("Overdraw mode was enabled for a render pass of this frame.");
        public static final /* enum */ CaptureMode FRAGMENT_COUNT = new CaptureMode("Fragment counts are available for a render pass of this frame.");
        public static final /* enum */ CaptureMode SHADER_MAP = new CaptureMode("Shadermap mode was enabled for a render pass of this frame.");
        public static final /* enum */ CaptureMode CAPTURE_ALL_ATTACHMENTS = new CaptureMode("All attachments were captured for a render pass of this frame.");
        private String tooltip;
        private static final /* synthetic */ CaptureMode[] ENUM$VALUES;

        static {
            ENUM$VALUES = new CaptureMode[]{NONE, OVERDRAW, FRAGMENT_COUNT, SHADER_MAP, CAPTURE_ALL_ATTACHMENTS};
        }

        private CaptureMode(String tooltip) {
            assert (tooltip != null);
            this.tooltip = tooltip;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        public static CaptureMode[] values() {
            CaptureMode[] captureModeArray = ENUM$VALUES;
            int n = captureModeArray.length;
            CaptureMode[] captureModeArray2 = new CaptureMode[n];
            System.arraycopy(ENUM$VALUES, 0, captureModeArray2, 0, n);
            return captureModeArray2;
        }

        public static CaptureMode valueOf(String string) {
            return Enum.valueOf(CaptureMode.class, string);
        }
    }
}

