/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractByteDataFreeAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FramebufferDiffAttachment
extends AbstractByteDataFreeAttachment {
    private static final long serialVersionUID = -2926925141134747260L;
    private static final byte[] IDENTIFIER = new byte[]{105, 109, 103, 100};
    private final int bytesPerPixel;
    private final int blockSize;
    private final int imageDataOffset;
    public final Dimension size;
    private final @NonNull AbstractConstantOrAliasSpecExtended format;
    private final @NonNull AbstractConstantOrAliasSpecExtended type;
    private final @NonNull AbstractConstantOrAliasSpecExtended attachment;
    private final int multiviewViewId;

    public FramebufferDiffAttachment(@NonNull AbstractConstantOrAliasSpecExtended attachment, @Nullable IByteDataProvider data) throws TraceParseException {
        this(attachment, data, null);
    }

    public FramebufferDiffAttachment(@NonNull AbstractConstantOrAliasSpecExtended attachment, @Nullable IByteDataProvider data, @Nullable Integer multiviewViewId) throws TraceParseException {
        super(data);
        this.attachment = attachment;
        int n = this.multiviewViewId = multiviewViewId != null ? multiviewViewId : 0;
        if (data == null || data.getLength() < 32) {
            throw new TraceParseException("Framebuffer diff. should have at least 32 bytes for the header.");
        }
        ByteBuffer bytes = data.getData();
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        byte[] id = new byte[4];
        bytes.get(id);
        if (!Arrays.equals(IDENTIFIER, id)) {
            throw new TraceParseException("Unrecognized framebuffer diff. identifer: " + Arrays.toString(id) + ".");
        }
        int width = bytes.getInt();
        int height = bytes.getInt();
        this.size = new Dimension(width, height);
        if (!this.size.isValid()) {
            throw new TraceParseException("Unsupported framebuffer diff. size: " + this.size + ".");
        }
        this.bytesPerPixel = bytes.getShort() & 0xFFFF;
        if (this.bytesPerPixel <= 0) {
            throw new TraceParseException("Unsupported framebuffer diff. bytesPerPixel: " + this.bytesPerPixel + ".");
        }
        this.blockSize = bytes.getShort() & 0xFFFF;
        this.format = KapiSpec.GLES.getConstantSpecByValue(NullUtils.longValueOf((long)((long)bytes.getInt() & 0xFFFFFFFFL)));
        this.type = KapiSpec.GLES.getConstantSpecByValue(NullUtils.longValueOf((long)((long)bytes.getInt() & 0xFFFFFFFFL)));
        byte[] padding = new byte[8];
        bytes.get(padding);
        if (this.blockSize <= 0) {
            throw new TraceParseException("Unsupported framebuffer diff. block size: " + this.blockSize + ".");
        }
        assert (bytes.position() == 32);
        this.imageDataOffset = bytes.position();
    }

    @Override
    public @NonNull IByteDataProvider getData() {
        return (IByteDataProvider)NullUtils.neverNull((Object)super.getData());
    }

    @Override
    public void process(@NonNull TraceStateSnapshot currentState) {
        FunctionCall functionCall = this.getParentFunctionCall();
        GlFramebufferAsset framebufferAsset = GlFramebufferAsset.getBoundFramebufferAsset(currentState, KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING);
        if (framebufferAsset != null) {
            FrameRenderPass firstRenderPass;
            framebufferAsset.addFramebufferDiff(currentState, functionCall, this);
            Frame parentFrame = functionCall.getParentFrame();
            if (parentFrame != null && !parentFrame.isCaptured() && (firstRenderPass = parentFrame.getFirstRenderPass()) != null) {
                FramebufferFeature newFramebufferFeature = new FramebufferFeature(FramebufferFeature.CaptureMode.NONE, true, parentFrame.isReplayed());
                firstRenderPass.setFramebufferFeature(newFramebufferFeature);
            }
        }
    }

    public void copyImageDataTo(byte[] target) {
        assert (target.length == this.size.getArea() * this.bytesPerPixel);
        IByteDataProvider byteData = this.getData();
        ByteBuffer bytes = byteData.getData();
        int imgLineSize = this.size.getWidth() * this.bytesPerPixel;
        int horizontalBlocks = (this.size.getWidth() + this.blockSize - 1) / this.blockSize;
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        int srcOffset = this.imageDataOffset;
        while (srcOffset < byteData.getLength()) {
            bytes.position(srcOffset);
            int blockId = bytes.getShort() & 0xFFFF;
            srcOffset = bytes.position();
            int y = blockId / horizontalBlocks * this.blockSize;
            int x = blockId % horizontalBlocks * this.blockSize;
            int remainingPixelsX = this.size.getWidth() - x;
            int remainingPixelsY = this.size.getHeight() - y;
            int imgOffset = (y * this.size.getWidth() + x) * this.bytesPerPixel;
            int thisBlockWidth = Math.min(this.blockSize, remainingPixelsX);
            int thisBlockHeight = Math.min(this.blockSize, remainingPixelsY);
            int blockLineLength = thisBlockWidth * this.bytesPerPixel;
            int j = 0;
            while (j < thisBlockHeight) {
                bytes.position(srcOffset);
                bytes.get(target, imgOffset, blockLineLength);
                srcOffset += blockLineLength;
                imgOffset += imgLineSize;
                ++j;
            }
        }
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getAttachment() {
        return this.attachment;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getFormat() {
        return this.format;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getType() {
        return this.type;
    }

    public @NonNull Integer getMultiviewViewId() {
        return NullUtils.intValueOf((int)this.multiviewViewId);
    }

    public int getViewId() {
        return this.multiviewViewId;
    }
}

