/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.ImageAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FramebufferAttachment
extends ImageAttachment {
    private static final long serialVersionUID = 8442431226485180168L;
    private final @NonNull AbstractConstantOrAliasSpecExtended attachment;
    private final int multiviewViewId;

    public FramebufferAttachment(@NonNull AbstractConstantOrAliasSpecExtended attachment, @NonNull AbstractConstantOrAliasSpecExtended format, @NonNull AbstractConstantOrAliasSpecExtended type, @NonNull Dimension size, @Nullable IByteDataProvider data) {
        this(attachment, format, type, size, data, null);
    }

    public FramebufferAttachment(@NonNull AbstractConstantOrAliasSpecExtended attachment, @NonNull AbstractConstantOrAliasSpecExtended format, @NonNull AbstractConstantOrAliasSpecExtended type, @NonNull Dimension size, @Nullable IByteDataProvider data, @Nullable Integer multiviewViewId) {
        super(format, type, size, data);
        this.attachment = attachment;
        this.multiviewViewId = multiviewViewId != null ? multiviewViewId : 0;
    }

    @Override
    public void process(@NonNull TraceStateSnapshot currentState) {
        GlFramebufferAsset framebufferAsset = GlFramebufferAsset.getBoundFramebufferAsset(currentState, KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING);
        IByteDataProvider provider = this.getData();
        if (framebufferAsset == null || provider == null || provider.isEmpty()) {
            return;
        }
        framebufferAsset.setFullBuffer(currentState, this.getParentFunctionCall(), this);
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getAttachment() {
        return this.attachment;
    }

    @Override
    public void doMidstreamProcessingForAsset(@NonNull TraceStateSnapshot currentState, @NonNull com.arm.mgd.core.asset.IAssetItem assetObject) throws Exception {
        assert (assetObject instanceof GlTextureSurfaceAsset);
        ((GlTextureSurfaceAsset)assetObject).addMidstreamTextureThumbnail(this);
    }

    @Override
    public <M, P extends IAssetItem<M, ?>> void doMidstreamProcessingForLightweightAsset(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject) throws Exception {
    }

    @Override
    public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> @NonNull V doMidstreamProcessingForLightweightAssetValue(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject, @NonNull V value) throws Exception {
        return value;
    }

    public @NonNull Integer getMultiviewViewId() {
        return NullUtils.intValueOf((int)this.multiviewViewId);
    }

    public int getViewId() {
        return this.multiviewViewId;
    }
}

