/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentBinding;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IFunctionCallRangeItem;
import com.arm.mgd.core.target.data.InterestingFunctionCall;
import com.arm.mgd.core.target.data.SingleFunctionCallItem;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.core.util.ChildrenStatisticsCache;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.core.util.Statistic;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class FrameRenderPass
implements INavigationElement<FrameRenderPass> {
    private final @NonNull List<@NonNull DrawFunctionCall> drawCalls = new ArrayList<DrawFunctionCall>();
    private final @NonNull List<@NonNull InterestingFunctionCall> interestingCalls = new ArrayList<InterestingFunctionCall>();
    private @NonNull Long fboId;
    private @NonNull List<@NonNull GlFramebufferAttachmentBinding> attachmentBindings;
    private final @NonNull List<@NonNull IFunctionCallRangeItem> functionCallRanges = new ArrayList<IFunctionCallRangeItem>();
    private final @NonNull GraphicsContext graphicsContext;
    private final int index;
    private final @NonNull Frame parentFrame;
    private @NonNull FramebufferFeature enabledFeature = FramebufferFeature.NOTHING;
    private final @NonNull ChildrenStatisticsCache statisticsCache = new ChildrenStatisticsCache(this);

    public FrameRenderPass(@NonNull Frame parentFrame, @NonNull GraphicsContext graphicsContext, @NonNull GlFramebufferAsset fboAsset, int index) {
        this.parentFrame = parentFrame;
        this.graphicsContext = graphicsContext;
        this.fboId = fboAsset.getId();
        this.index = index;
        this.attachmentBindings = fboAsset.getAttachmentBindings();
        if (!FrameRenderPass.doesTraceSupportPerRenderPassFeature(parentFrame.getParentModel())) {
            if (parentFrame.containsLegacyCapture()) {
                this.enabledFeature = parentFrame.getLegacyFramebufferFeature();
            } else {
                this.enabledFeature = FramebufferFeature.createFramebufferFeatureFromFunctionCall(parentFrame.getParentModel().getCallItem(parentFrame.getFirstFunctionIndex()));
                if (!this.enabledFeature.equals(FramebufferFeature.NOTHING)) {
                    parentFrame.setContainsLegacyCapture(this.enabledFeature);
                }
            }
        }
    }

    private static boolean doesTraceSupportPerRenderPassFeature(@NonNull TraceDataModel traceDataModel) {
        String originalVersion = traceDataModel.getOriginalVersion();
        if (originalVersion.startsWith("B")) {
            return false;
        }
        int version = Integer.parseInt(originalVersion.substring(1), 10);
        return version >= 5;
    }

    public synchronized void addFunctionCall(@NonNull FunctionCall fc) {
        if (!this.functionCallRanges.isEmpty()) {
            IFunctionCallRangeItem lastItem = this.functionCallRanges.get(this.functionCallRanges.size() - 1);
            assert (lastItem.isBefore(fc));
            if (lastItem.canBeExtendedBy(fc)) {
                this.functionCallRanges.set(this.functionCallRanges.size() - 1, lastItem.replaceByExtension(fc));
            } else {
                this.functionCallRanges.add(new SingleFunctionCallItem(fc));
            }
        } else {
            this.functionCallRanges.add(new SingleFunctionCallItem(fc));
        }
        if (fc.getFunctionSpec().isDrawCall()) {
            this.drawCalls.add((DrawFunctionCall)fc);
        }
        this.updateFramebufferFeature(fc);
        if (fc.getFunctionSpec().isInterestingCall()) {
            this.interestingCalls.add((InterestingFunctionCall)fc);
        }
    }

    public void updateFramebufferFeature(@NonNull FunctionCall fc) {
        if (this.enabledFeature.equals(FramebufferFeature.NOTHING)) {
            if (this.parentFrame.containsLegacyCapture()) {
                this.enabledFeature = this.parentFrame.getLegacyFramebufferFeature();
            } else if (this.parentFrame.getFirstFunctionIndex() == fc.getIndex() || fc.getFunctionSpec().isDrawCall() || fc.getAsynchronousFunctionCallUid() != null) {
                this.enabledFeature = FramebufferFeature.createFramebufferFeatureFromFunctionCall(fc);
            }
        }
        if (this.enabledFeature.isReplayEnabled()) {
            this.parentFrame.setReplayed(true);
        }
    }

    void setFramebufferFeature(@NonNull FramebufferFeature newFramebufferFeature) {
        this.enabledFeature = newFramebufferFeature;
    }

    public @NonNull FramebufferFeature getEnabledFeature() {
        return this.enabledFeature;
    }

    public synchronized boolean contains(final @NonNull FunctionCall functionCall) {
        BinarySearchList.Comparator<@NonNull IFunctionCallRangeItem> comparator = new BinarySearchList.Comparator<IFunctionCallRangeItem>(){

            @Override
            public int compare(@NonNull IFunctionCallRangeItem that) {
                return that.compareContains(functionCall);
            }
        };
        IFunctionCallRangeItem result = BinarySearchList.usingComparator(this.functionCallRanges, comparator);
        return result != null;
    }

    public synchronized @NonNull List<@NonNull DrawFunctionCall> getDrawCalls() {
        return new ReadOnlySubList<DrawFunctionCall>(this.drawCalls, 0, this.drawCalls.size());
    }

    public int getDrawCallCount() {
        return this.drawCalls.size();
    }

    public synchronized @NonNull List<@NonNull InterestingFunctionCall> getInterestingCalls() {
        return new ReadOnlySubList<InterestingFunctionCall>(this.interestingCalls, 0, this.interestingCalls.size());
    }

    public int getInterestingCallCount() {
        return this.interestingCalls.size();
    }

    public @NonNull List<@NonNull IFunctionCallRangeItem> getFunctionCallRanges() {
        return NullUtils.unmodifiableList(this.functionCallRanges);
    }

    public synchronized int getFirstInterestingCallFunctionIndex() {
        if (!this.interestingCalls.isEmpty()) {
            return this.interestingCalls.get(0).getIndex();
        }
        if (!this.functionCallRanges.isEmpty()) {
            return this.functionCallRanges.get(0).getFirstFunctionIndex();
        }
        return this.parentFrame.getFirstFunctionIndex();
    }

    public synchronized int getFirstDrawCallFunctionIndex() {
        if (!this.drawCalls.isEmpty()) {
            return this.drawCalls.get(0).getIndex();
        }
        if (!this.functionCallRanges.isEmpty()) {
            return this.functionCallRanges.get(0).getFirstFunctionIndex();
        }
        return this.parentFrame.getFirstFunctionIndex();
    }

    public int getInterestingCallIndex(@NonNull InterestingFunctionCall fc) {
        int result = BinarySearchList.getIndexUsingComparator(this.getInterestingCalls(), that -> that.compareTo(fc));
        if (result >= 0) {
            return result;
        }
        throw new IllegalArgumentException("Interesting call is not child of render pass");
    }

    public @NonNull Frame getFrame() {
        return this.parentFrame;
    }

    public @NonNull Long getFramebufferId() {
        return this.fboId;
    }

    public @NonNull GraphicsContext getGraphicsContext() {
        return this.graphicsContext;
    }

    @Override
    public int getLabelIndex() {
        return this.index;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull String framebuffer = this.graphicsContext.getHandle() == 0L ? "No active context" : "RenderPass " + this.getLabelIndex() + " (Framebuffer " + this.fboId + ")";
        return framebuffer;
    }

    @Override
    public @NonNull String getLongLabelText() {
        return this.getLabelText();
    }

    @Override
    public @NonNull String getToolTipText() {
        return String.valueOf(this.getLongLabelText()) + String.format("; Context 0x%s", Long.toHexString(this.graphicsContext.getHandle()));
    }

    public synchronized int getLastInterestingCallFunctionIndex() {
        if (!this.interestingCalls.isEmpty()) {
            return this.interestingCalls.get(this.interestingCalls.size() - 1).getIndex();
        }
        if (!this.functionCallRanges.isEmpty()) {
            return this.functionCallRanges.get(this.functionCallRanges.size() - 1).getLastFunctionCallIndex();
        }
        return this.parentFrame.getFirstFunctionIndex();
    }

    public boolean isSameRenderPassAs(@NonNull GlFramebufferAsset thatFBO) {
        return this.fboId.equals(thatFBO.getId()) && this.attachmentBindings.equals(thatFBO.getAttachmentBindings());
    }

    public String toString() {
        return String.format("FrameRenderPass{index = %s, functionCallRanges = %s}", String.valueOf(this.index), this.functionCallRanges);
    }

    @Override
    public @NonNull List<@NonNull InterestingFunctionCall> getChildren() {
        return this.getInterestingCalls();
    }

    @Override
    public boolean isTheChildrenListFinal() {
        return this.parentFrame.isTheChildrenListFinal();
    }

    @Override
    public int compareTo(FrameRenderPass o) {
        return Integer.compare(this.index, o.index);
    }

    @Override
    public boolean hasDataForStatisticType(@NonNull IStatisticType statsType) {
        if (statsType == CommonStatistics.NUMBER_OF_DRAW_CALLS) {
            return this.drawCalls.size() != 0;
        }
        return this.statisticsCache.hasDataForStatisticType(statsType);
    }

    @Override
    public @NonNull Statistic getStatistic(@NonNull IStatisticType statsType) {
        if (statsType == CommonStatistics.NUMBER_OF_DRAW_CALLS) {
            return new Statistic(statsType, this.drawCalls.size());
        }
        return this.statisticsCache.getStat(statsType);
    }

    public boolean isReplayed() {
        return this.parentFrame.isReplayed();
    }

    public boolean isCaptured() {
        return this.enabledFeature.isCaptureEnabled();
    }

    public @NonNull FramebufferFeature.CaptureMode getCaptureMode() {
        return this.enabledFeature.getCaptureMode();
    }

    public void setFBO(@NonNull GlFramebufferAsset fboAsset) {
        this.fboId = fboAsset.getId();
        this.attachmentBindings = fboAsset.getAttachmentBindings();
    }
}

