/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.AssetProcessor;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.FunctionBuilder;
import com.arm.mgd.core.replay.OverriddenFrameData;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.TargetStateMap;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.core.target.data.Frames;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ScreenshotAttachment;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.io.LiveProcessTarget;
import com.arm.mgd.core.util.ChildrenStatisticsCache;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.IReplayableListener;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.core.util.Statistic;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Frame
implements INavigationElement<Frame> {
    private final int frameId;
    private final int firstFunctionIndex;
    private int lastFunctionIndex;
    private long totalMemoryAllocation = 0L;
    private final @NonNull TraceDataModel traceDataModel;
    private final @NonNull Map<GraphicsContext, List<FrameRenderPass>> perContextRenderPassMap = new HashMap<GraphicsContext, List<FrameRenderPass>>();
    private final @NonNull List<FrameRenderPass> renderPassList = new ArrayList<FrameRenderPass>();
    private boolean containsLegacyCapture = false;
    private @NonNull FramebufferFeature legacyFramebufferFeature = new FramebufferFeature(FramebufferFeature.CaptureMode.NONE, false, false);
    private @Nullable ScreenshotAttachment screenshot;
    volatile boolean replayable = false;
    volatile boolean calculatingReplayable = false;
    volatile boolean calculatedReplayable = false;
    private static final @NonNull ExecutorService EXECUTOR = NamedExecutors.cachedFiniteThreadPool(1, 60L, TimeUnit.SECONDS, new NamedThreadFactory("FramePool"));
    private FrameOverrides frameOverrides = new FrameOverrides();
    boolean complete = false;
    List<FunctionCall> replayPreFrameStateCache = null;
    List<FunctionCall> replayPostFrameStateCache = null;
    List<FunctionCall> replayGenericVertexCallCache = null;
    private boolean replayed;
    private final @NonNull ChildrenStatisticsCache statisticsCache = new ChildrenStatisticsCache(this);
    private boolean functionHasMidstreamTraceData;
    private final Set<IReplayableListener> replayListenerList = new HashSet<IReplayableListener>();

    Frame(@NonNull TraceDataModel traceDataModel, int frameId, int firstFunctionIndex, boolean replayed) {
        assert (traceDataModel != null);
        assert (frameId >= 0);
        assert (firstFunctionIndex >= 0);
        this.traceDataModel = traceDataModel;
        this.frameId = frameId;
        this.firstFunctionIndex = firstFunctionIndex;
        this.lastFunctionIndex = this.firstFunctionIndex - 1;
        this.replayed = replayed;
    }

    Frame(@NonNull TraceDataModel traceDataModel, int frameId, int firstFunctionIndex) {
        this(traceDataModel, frameId, firstFunctionIndex, false);
    }

    public void setFrameOverrides(FrameOverrides currentOverrides) {
        this.frameOverrides = new FrameOverrides();
        for (AbstractFrameOverride afo : currentOverrides) {
            this.frameOverrides.add(afo);
        }
    }

    @Override
    public int getLabelIndex() {
        return this.frameId;
    }

    public FrameOverrides getFrameOverrides() {
        return this.frameOverrides;
    }

    int incrementLastFunctionIndex(@NonNull TraceStateSnapshot latestSnapshot) {
        int newLastFunctionIndex = this.lastFunctionIndex + 1;
        assert (latestSnapshot.getCurrentSelection() == newLastFunctionIndex);
        FunctionCall fc = this.traceDataModel.getCallItem(newLastFunctionIndex);
        this.functionHasMidstreamTraceData |= fc.hasMidstreamTraceData();
        this.addFunctionToRenderPass(latestSnapshot.getCurrentContext(), (GlFramebufferAsset)NullUtils.neverNull((Object)GlFramebufferAsset.getBoundFramebufferAsset(latestSnapshot, KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING)), fc);
        this.lastFunctionIndex = newLastFunctionIndex;
        return this.lastFunctionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFunctionToRenderPass(@NonNull GraphicsContext graphicsContext, @NonNull GlFramebufferAsset fboAsset, @NonNull FunctionCall fc) {
        Map<GraphicsContext, List<FrameRenderPass>> map = this.perContextRenderPassMap;
        synchronized (map) {
            FrameRenderPass currentRenderPass;
            List<FrameRenderPass> renderPasses = this.perContextRenderPassMap.get(graphicsContext);
            if (renderPasses == null) {
                renderPasses = new ArrayList<FrameRenderPass>();
                this.perContextRenderPassMap.put(graphicsContext, renderPasses);
            }
            FrameRenderPass frameRenderPass = currentRenderPass = !renderPasses.isEmpty() ? renderPasses.get(renderPasses.size() - 1) : null;
            if (currentRenderPass == null) {
                currentRenderPass = this.createNewRenderPass(graphicsContext, fboAsset, renderPasses);
            } else {
                boolean sameRenderPass = currentRenderPass.isSameRenderPassAs(fboAsset);
                if (!sameRenderPass) {
                    if (currentRenderPass.getDrawCallCount() > 0) {
                        currentRenderPass = this.createNewRenderPass(graphicsContext, fboAsset, renderPasses);
                    } else {
                        currentRenderPass.setFBO(fboAsset);
                    }
                }
            }
            currentRenderPass.addFunctionCall(fc);
        }
    }

    private @NonNull FrameRenderPass createNewRenderPass(@NonNull GraphicsContext graphicsContext, @NonNull GlFramebufferAsset fboAsset, List<FrameRenderPass> renderPasses) {
        FrameRenderPass newRenderPass = new FrameRenderPass(this, graphicsContext, fboAsset, this.renderPassList.size());
        renderPasses.add(newRenderPass);
        this.renderPassList.add(newRenderPass);
        return newRenderPass;
    }

    protected boolean areFunctionCallsReplayable() {
        List<@NonNull FunctionCall> theFunctions = this.traceDataModel.getCallItems(this.firstFunctionIndex, this.lastFunctionIndex - this.firstFunctionIndex + 1);
        if (theFunctions.isEmpty()) {
            return false;
        }
        SynchronousTraceStateSnapshot stateSnapshot = new SynchronousTraceStateSnapshot(this.traceDataModel);
        stateSnapshot.setSelectedFunction(theFunctions.get(0).getIndex());
        if (stateSnapshot.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_CONTEXT).getLastAffectedByFunction() == null) {
            return false;
        }
        StateItem currentContextState = stateSnapshot.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_CONTEXT);
        String startingContext = currentContextState.getValue()[0].toString();
        for (FunctionCall element : theFunctions) {
            stateSnapshot.setSelectedFunction(element.getIndex());
            currentContextState = stateSnapshot.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_CONTEXT);
            String currentContext = currentContextState.getValue()[0].toString();
            if (!currentContext.equals(startingContext)) {
                CoreLogging.info(this.traceDataModel, String.valueOf(element.getFunctionSpec().getName()) + " is from another context and is therefore not replayable.");
                return false;
            }
            if (element.getFunctionSpec().isFrameReplayable()) continue;
            CoreLogging.info(this.traceDataModel, String.valueOf(element.getFunctionSpec().getName()) + " is a not a replayable function (there may also be other non-replayable functions in the frame).");
            return false;
        }
        return true;
    }

    boolean isStateReplayable() {
        int firstCall = Math.max(this.getFirstFunctionIndex() - 1, 0);
        int lastCall = this.getLastFunctionIndex();
        SynchronousTraceStateSnapshot stateSnapshot = new SynchronousTraceStateSnapshot(this.traceDataModel);
        stateSnapshot.setSelectedFunction(firstCall);
        TargetStateMap targetStateFrameStart = stateSnapshot.getStateData(KapiSpec.GLES);
        long changedStateItemsAtStart = targetStateFrameStart.getStateItems().stream().filter(StateItem::isChanged).count();
        GlVertexArrayObjectAsset vao = GlVertexArrayObjectAsset.getCurrentVertexArrayObject(stateSnapshot);
        if (vao == null) {
            stateSnapshot.setSelectedFunction(lastCall);
            GlVertexArrayObjectAsset vao2 = GlVertexArrayObjectAsset.getCurrentVertexArrayObject(stateSnapshot);
            if (vao2 != null) {
                return false;
            }
        } else {
            HashMap<Long, GlVertexAttributeAsset> genericVertexAttribArrayStart = new HashMap<Long, GlVertexAttributeAsset>(vao.getVertexAttributesCollection());
            HashSet genericVertexAttribArrayActive = new HashSet();
            genericVertexAttribArrayStart.forEach((index, attribute) -> {
                if (attribute.isArrayEnabled()) {
                    genericVertexAttribArrayActive.add(index);
                }
            });
            stateSnapshot.setSelectedFunction(lastCall);
            vao = GlVertexArrayObjectAsset.getCurrentVertexArrayObject(stateSnapshot);
            if (vao == null) {
                return false;
            }
            HashMap<Long, GlVertexAttributeAsset> genericVertexAttribArrayEnd = new HashMap<Long, GlVertexAttributeAsset>(vao.getVertexAttributesCollection());
            if (genericVertexAttribArrayStart.size() != genericVertexAttribArrayEnd.size()) {
                CoreLogging.info(this.traceDataModel, "New generic vertex attributes were using this frame. Therefore the frame is not replayable");
                return false;
            }
            for (Map.Entry entry : genericVertexAttribArrayEnd.entrySet()) {
                if (genericVertexAttribArrayActive.contains(entry.getKey()) || !((GlVertexAttributeAsset)entry.getValue()).isArrayEnabled()) continue;
                CoreLogging.info(this.traceDataModel, "Generic Vertex Attribute has been enabled in this frame. Therefore the frame is not replayable");
                return false;
            }
        }
        stateSnapshot.setSelectedFunction(lastCall);
        TargetStateMap targetStateFrameEnd = stateSnapshot.getStateData(KapiSpec.GLES);
        long changedStateItemsAtEnd = targetStateFrameEnd.getStateItems().stream().filter(StateItem::isChanged).count();
        if (changedStateItemsAtStart != changedStateItemsAtEnd) {
            CoreLogging.info(this.traceDataModel, "New state change happened in the frame therefore the frame is not replayable");
            return false;
        }
        return true;
    }

    public void replayFrame(boolean capture, @NonNull FrameOverrides currentOverrides, ICoreProgressMonitor replayFrameOperationProgressMonitor, ICoreProgressMonitor sendingReplayCommandsProgressMonitor) {
        if (!(this.traceDataModel.getParentProcessTarget() instanceof LiveProcessTarget)) {
            assert (false) : "Replay only valid for live targets";
            return;
        }
        LiveProcessTarget processTarget = (LiveProcessTarget)this.traceDataModel.getParentProcessTarget();
        Frames theFrames = this.traceDataModel.getFrames();
        Frame theFrame = null;
        if (replayFrameOperationProgressMonitor == null) {
            replayFrameOperationProgressMonitor = ICoreProgressMonitor.NULL_MONITOR;
        }
        replayFrameOperationProgressMonitor.setTask("Finding frame to replay", 1);
        int i = theFrames.count() - 1;
        while (i >= 0) {
            theFrame = theFrames.getFrameAt(i);
            if (!theFrame.isReplayed()) break;
            --i;
        }
        if (theFrame == null) {
            return;
        }
        if (replayFrameOperationProgressMonitor.isCancelled()) {
            return;
        }
        try {
            FunctionCall[] theFrameFunctions = theFrame.replayFrameBuilder(currentOverrides, replayFrameOperationProgressMonitor);
            if (!sendingReplayCommandsProgressMonitor.isCancelled()) {
                sendingReplayCommandsProgressMonitor.setTask("Sending replay commands", theFrameFunctions.length);
                theFrames.setNextFrameIsReplayedFrame(true);
                theFrames.setNextFrameOverrides(currentOverrides);
                if (capture) {
                    processTarget.sendReplayFrameCaptureCommand();
                } else {
                    processTarget.sendReplayFrameCommand();
                }
                processTarget.sendReplayFunctions(theFrameFunctions, sendingReplayCommandsProgressMonitor);
                sendingReplayCommandsProgressMonitor.finished();
                processTarget.sendEndFrameReplayCommand();
            }
        }
        catch (Exception e) {
            CoreLogging.severe(this.traceDataModel, e, null);
        }
    }

    protected void addTextureCalls(List<FunctionCall> rebuiltFrame, List<@NonNull FunctionCall> theFunctions) {
        SynchronousTraceStateSnapshot currentState = new SynchronousTraceStateSnapshot(this.traceDataModel);
        for (FunctionCall currentFunction : theFunctions) {
            if (!currentFunction.getFunctionSpec().isTextureCall() && !currentFunction.getFunctionSpec().isCompressedTextureCall()) continue;
            StateItem boundTextureState = null;
            StateItem activeTextureState = null;
            ArrayDeque<FunctionCall> functionsToBeAdded = new ArrayDeque<FunctionCall>();
            currentState.setSelectedFunction(currentFunction.getIndex());
            AbstractConstantOrAliasSpecExtended target = currentFunction.getTextureTarget();
            assert (target != null);
            boundTextureState = AssetProcessor.getTextureCurrentBoundState(currentState, target);
            if (boundTextureState == null) {
                TraceAnalysisLogger.error(currentState, currentFunction, "No texture is bound to " + target.getName() + ".");
                continue;
            }
            activeTextureState = currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_ACTIVE_TEXTURE);
            FunctionCall activeTextureCall = activeTextureState.getLastAffectedByFunction();
            FunctionCall boundCall = boundTextureState.getLastAffectedByFunction();
            if (activeTextureCall != null) {
                rebuiltFrame.add(activeTextureCall);
            }
            if (boundCall != null) {
                rebuiltFrame.add(boundCall);
            }
            FunctionCall previousTextureCall = currentFunction;
            AbstractConstantOrAliasSpecExtended previousTarget = null;
            do {
                currentState.setSelectedFunction(previousTextureCall.getIndex() - 1);
                GlTextureAsset textureAsset = AssetProcessor.getTextureAssetByConstantSpec(currentFunction, currentState, target);
                if (textureAsset == null || (previousTextureCall = textureAsset.getPreviousModificationFunction()) == null) break;
                previousTarget = previousTextureCall.getTextureTarget();
                if (previousTextureCall.getIndex() >= this.firstFunctionIndex || !target.equals(previousTarget)) continue;
                functionsToBeAdded.addFirst(previousTextureCall);
            } while (!target.equals(previousTarget) || !KapiSpec.GLES.functions.GLTEXIMAGE2D.equals(previousTextureCall.getFunctionSpec()) && !KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D.equals(previousTextureCall.getFunctionSpec()));
            rebuiltFrame.addAll(functionsToBeAdded);
        }
    }

    protected void addBufferCalls(List<FunctionCall> rebuiltFrame, List<@NonNull FunctionCall> theFunctions) {
        SynchronousTraceStateSnapshot currentState = new SynchronousTraceStateSnapshot(this.traceDataModel);
        for (FunctionCall currentFunction : theFunctions) {
            if (!currentFunction.getFunctionSpec().isBufferCall()) continue;
            ArrayDeque<FunctionCall> functionsToBeAdded = new ArrayDeque<FunctionCall>();
            currentState.setSelectedFunction(currentFunction.getIndex());
            AbstractConstantOrAliasSpecExtended target = KapiSpec.GLES.functions.GLBUFFERDATA.equals(currentFunction.getFunctionSpec()) ? GLES.GlBufferDataDecorator.getArgumentTarget(currentFunction) : GLES.GlBufferSubDataDecorator.getArgumentTarget(currentFunction);
            assert (target != null);
            StateItem targetBindingState = AssetProcessor.getTargetBufferStateItem(currentState, target);
            if (targetBindingState == null) {
                TraceAnalysisLogger.error(currentState, currentFunction, "glBuffer call without a bound buffer.");
                continue;
            }
            FunctionCall bindingFunction = targetBindingState.getLastAffectedByFunction();
            if (bindingFunction == null) continue;
            rebuiltFrame.add(bindingFunction);
            FunctionCall previousBufferCall = currentFunction;
            GlBufferAsset originalBufferAsset = (GlBufferAsset)targetBindingState.getValueAsAsset();
            if (originalBufferAsset != null) {
                do {
                    currentState.setSelectedFunction(previousBufferCall.getIndex() - 1);
                    GlBufferAsset bufferAsset = (GlBufferAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC).get(originalBufferAsset.getId());
                    if (bufferAsset == null || (previousBufferCall = bufferAsset.getPreviousModificationFunction()) == null) break;
                    if (previousBufferCall.getIndex() >= this.firstFunctionIndex) continue;
                    functionsToBeAdded.addFirst(previousBufferCall);
                } while (!KapiSpec.GLES.functions.GLBUFFERDATA.equals(previousBufferCall.getFunctionSpec()));
            }
            rebuiltFrame.addAll(functionsToBeAdded);
        }
    }

    private static List<AbstractFrameOverride.AbstractAppliedOverride> addOverrides(@NonNull ICoreProgressMonitor monitor, OverriddenFrameData overridenFrameData, FrameOverrides currentFrameOverrides) {
        ArrayList<AbstractFrameOverride.AbstractAppliedOverride> appliedOverrides = new ArrayList<AbstractFrameOverride.AbstractAppliedOverride>();
        monitor.setTask("Generating frame override code", currentFrameOverrides.size());
        for (AbstractFrameOverride afo : currentFrameOverrides) {
            if (afo.canApplyOverride(overridenFrameData.getOriginalFrame())) {
                AbstractFrameOverride.AbstractAppliedOverride override = afo.addOverride(overridenFrameData);
                if (override != null) {
                    appliedOverrides.add(override);
                } else {
                    CoreLogging.log(overridenFrameData.getOriginalFrame().traceDataModel, Level.WARNING, "AbstractFrameOverride: " + afo + " claimes it can override this frame, but failed");
                    return null;
                }
            }
            if (!Frame.stepMonitorAndCheckCancelled(monitor, 1)) continue;
            return null;
        }
        return appliedOverrides;
    }

    private static boolean removeOverrides(@NonNull ICoreProgressMonitor monitor, OverriddenFrameData overridenFrameData, List<AbstractFrameOverride.AbstractAppliedOverride> appliedOverrides) {
        monitor.setTask("Generating frame override cleanup code", appliedOverrides.size());
        int i = appliedOverrides.size() - 1;
        while (i >= 0) {
            if (!appliedOverrides.get(i).removeOverride(overridenFrameData)) {
                return false;
            }
            if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
                return false;
            }
            --i;
        }
        return true;
    }

    private static boolean stepMonitorAndCheckCancelled(@NonNull ICoreProgressMonitor monitor, int amount) {
        monitor.incProgress(amount);
        return monitor.isCancelled();
    }

    public FunctionCall[] replayFrameBuilder(@NonNull FrameOverrides currentFrameOverrides, @NonNull ICoreProgressMonitor monitor) {
        monitor.setTask("Building replay frame", 12);
        SynchronousTraceStateSnapshot currentSnapshot = new SynchronousTraceStateSnapshot(this.traceDataModel);
        OverriddenFrameData overiddenFrameData = new OverriddenFrameData(this);
        List<FunctionCall> theFrame = overiddenFrameData.getReplayFunctions();
        if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
            return null;
        }
        currentSnapshot.setSelectedFunction(this.getFirstFunctionIndex());
        StateItem currentDisplay = currentSnapshot.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_DISPLAY);
        StateItem currentContext = currentSnapshot.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_CONTEXT);
        StateItem currentReadSurface = currentSnapshot.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_READ_SURFACE);
        StateItem currentDrawSurface = currentSnapshot.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_DRAW_SURFACE);
        IAssetItem currentDisplayAsset = currentDisplay.getValueAsAsset();
        IAssetItem currentContextAsset = currentContext.getValueAsAsset();
        IAssetItem currentReadSurfaceAsset = currentReadSurface.getValueAsAsset();
        IAssetItem currentDrawSurfaceAsset = currentDrawSurface.getValueAsAsset();
        Pointer currentDisplayValue = Pointer.valueOf(currentDisplayAsset != null ? currentDisplayAsset.getId() : 0L);
        Pointer currentDrawSurfaceValue = Pointer.valueOf(currentDrawSurfaceAsset != null ? currentDrawSurfaceAsset.getId() : 0L);
        Pointer currentReadSurfaceValue = Pointer.valueOf(currentReadSurfaceAsset != null ? currentReadSurfaceAsset.getId() : 0L);
        Pointer currentContextValue = Pointer.valueOf(currentContextAsset != null ? currentContextAsset.getId() : 0L);
        FunctionBuilder.addFunction(theFrame, this.traceDataModel, KapiSpec.EGL.functions.EGLMAKECURRENT, FunctionBuilder.args(currentDisplayValue, currentDrawSurfaceValue, currentReadSurfaceValue, currentContextValue), KapiSpec.EGL.constants.EGL_TRUE.getResolvedValue());
        if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
            return null;
        }
        if (this.replayPreFrameStateCache == null) {
            this.buildState(this.firstFunctionIndex - 1, null);
        }
        theFrame.addAll(this.replayPreFrameStateCache);
        if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
            return null;
        }
        List<AbstractFrameOverride.AbstractAppliedOverride> appliedOverrides = null;
        if (this.lastFunctionIndex - this.firstFunctionIndex > 0) {
            List<@NonNull FunctionCall> theFunctions = this.traceDataModel.getCallItems(this.getFirstFunctionIndex(), this.getLastFunctionIndex() - this.getFirstFunctionIndex());
            if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
                return null;
            }
            appliedOverrides = Frame.addOverrides(monitor, overiddenFrameData, currentFrameOverrides);
            if (appliedOverrides == null) {
                return null;
            }
            monitor.setTask("Building replay frame", 12);
            if (Frame.stepMonitorAndCheckCancelled(monitor, 5)) {
                return null;
            }
            if (this.replayGenericVertexCallCache == null) {
                this.addGenericVertexCalls(theFunctions);
            }
            theFrame.addAll(this.replayGenericVertexCallCache);
            if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
                return null;
            }
            this.addBufferCalls(theFrame, theFunctions);
            if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
                return null;
            }
            this.addTextureCalls(theFrame, theFunctions);
            if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
                return null;
            }
            theFrame.addAll(theFunctions);
        }
        monitor.setTask("Building replay frame", 12);
        if (Frame.stepMonitorAndCheckCancelled(monitor, 9)) {
            return null;
        }
        if (!Frame.removeOverrides(monitor, overiddenFrameData, appliedOverrides)) {
            return null;
        }
        monitor.setTask("Building replay frame", 12);
        if (Frame.stepMonitorAndCheckCancelled(monitor, 10)) {
            return null;
        }
        if (this.replayPostFrameStateCache == null) {
            this.buildState(this.firstFunctionIndex - 1, this.lastFunctionIndex);
        }
        theFrame.addAll(this.replayPostFrameStateCache);
        if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
            return null;
        }
        FunctionCall endOfFrameCall = this.traceDataModel.getCallItem(this.lastFunctionIndex);
        theFrame.add(endOfFrameCall);
        if (Frame.stepMonitorAndCheckCancelled(monitor, 1)) {
            return null;
        }
        return theFrame.toArray(new FunctionCall[0]);
    }

    private void addGenericVertexCalls(List<@NonNull FunctionCall> theFunctions) {
        TreeSet<Long> vertexAttribIds = new TreeSet<Long>();
        ArrayList<FunctionCall> functionsToAdd = new ArrayList<FunctionCall>();
        for (FunctionCall currentFunction : theFunctions) {
            if (KapiSpec.GLES.functions.GLDISABLEVERTEXATTRIBARRAY.equals(currentFunction.getFunctionSpec())) {
                vertexAttribIds.add(GLES.GlDisableVertexAttribArrayDecorator.getArgumentIndex(currentFunction));
            }
            if (!KapiSpec.GLES.functions.GLENABLEVERTEXATTRIBARRAY.equals(currentFunction.getFunctionSpec())) continue;
            vertexAttribIds.add(GLES.GlEnableVertexAttribArrayDecorator.getArgumentIndex(currentFunction));
        }
        SynchronousTraceStateSnapshot currentSnapshot = new SynchronousTraceStateSnapshot(this.traceDataModel);
        currentSnapshot.setSelectedFunction(Math.max(this.getFirstFunctionIndex() - 1, 0));
        block1: for (Long vertexAttribId : vertexAttribIds) {
            GlVertexAttributeAsset attrib;
            FunctionCall theFunction;
            GlVertexArrayObjectAsset vao;
            while ((vao = GlVertexArrayObjectAsset.getCurrentVertexArrayObject(currentSnapshot)) != null && (theFunction = (attrib = vao.getVertexAttributeAssetById(vertexAttribId)).getPreviousModificationFunction()) != null) {
                if (KapiSpec.GLES.functions.GLDISABLEVERTEXATTRIBARRAY.equals(theFunction.getFunctionSpec()) || KapiSpec.GLES.functions.GLENABLEVERTEXATTRIBARRAY.equals(theFunction.getFunctionSpec())) {
                    functionsToAdd.add(theFunction);
                    continue block1;
                }
                if (theFunction.getIndex() <= 0) continue block1;
                currentSnapshot.setSelectedFunction(theFunction.getIndex() - 1);
            }
        }
        this.replayGenericVertexCallCache = functionsToAdd;
    }

    private void buildState(int frameStartLocation, @Nullable Integer frameEndLocation) {
        assert (frameEndLocation == null || frameStartLocation < frameEndLocation);
        boolean isStatePreFrame = frameEndLocation == null;
        int stateSnapshotLocation = frameEndLocation != null ? frameEndLocation : frameStartLocation;
        SynchronousTraceStateSnapshot stateSnapshot = new SynchronousTraceStateSnapshot(this.traceDataModel);
        stateSnapshot.setSelectedFunction(stateSnapshotLocation);
        TargetStateMap targetState = stateSnapshot.getStateData(KapiSpec.GLES);
        ArrayList<FunctionCall> stateFunctionCalls = new ArrayList<FunctionCall>();
        for (StateItem stateItem : targetState.getStateItems()) {
            if (!stateItem.isChanged() || stateItem.getStateSpec().isReadOnly()) continue;
            FunctionCall lastFunction = stateItem.getLastAffectedByFunction();
            assert (lastFunction != null);
            if (!isStatePreFrame && lastFunction.getIndex() <= frameStartLocation || stateFunctionCalls.contains(lastFunction)) continue;
            stateFunctionCalls.add(lastFunction);
        }
        stateFunctionCalls.sort((a, b) -> a.compareTo((FunctionCall)b));
        if (isStatePreFrame) {
            this.replayPreFrameStateCache = stateFunctionCalls;
        } else {
            this.replayPostFrameStateCache = stateFunctionCalls;
        }
    }

    public boolean isFrameReplayable(IReplayableListener listener) {
        if (!this.calculatedReplayable) {
            this.calculateReplayable(listener);
        }
        return this.replayable;
    }

    protected boolean getCalculatedReplayable() {
        return this.calculatedReplayable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateReplayable(IReplayableListener listener) {
        Set<IReplayableListener> set = this.replayListenerList;
        synchronized (set) {
            this.replayListenerList.add(listener);
        }
        if (this.calculatingReplayable) {
            return;
        }
        this.calculatingReplayable = true;
        class DeferredReplayChecker
        implements Runnable {
            private final Frame frame;

            DeferredReplayChecker(Frame frame2) {
                this.frame = frame2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Frame.this.replayable = !Frame.this.complete ? false : (Frame.this.isReplayed() ? true : Frame.this.isStateReplayable() && Frame.this.areFunctionCallsReplayable());
                Frame.this.calculatingReplayable = false;
                Frame.this.calculatedReplayable = true;
                Set<IReplayableListener> set = Frame.this.replayListenerList;
                synchronized (set) {
                    for (IReplayableListener eachListener : Frame.this.replayListenerList) {
                        if (eachListener == null) continue;
                        eachListener.onReplayStateUpdated(Frame.this.traceDataModel, this.frame);
                    }
                    Frame.this.replayListenerList.clear();
                }
            }

            public String toString() {
                return "DeferredReplayChecker for frame #" + this.frame.frameId;
            }
        }
        DeferredReplayChecker runnable = new DeferredReplayChecker(this);
        EXECUTOR.execute(runnable);
    }

    public String toString() {
        return "Frame id=" + this.frameId + " (" + this.firstFunctionIndex + " - " + this.lastFunctionIndex + ")";
    }

    @Override
    public String getLabelText() {
        return "Frame " + this.frameId;
    }

    @Override
    public @NonNull String getLongLabelText() {
        return this.getLabelText();
    }

    @Override
    public @NonNull String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLabelText());
        if (!this.isTheChildrenListFinal()) {
            stringBuilder.append("\nThis frame is not complete.");
        }
        for (FramebufferFeature feature : this.getFramebufferFeatures()) {
            String featureTooltip = feature.getCaptureMode().getToolTip();
            if (featureTooltip.isEmpty()) continue;
            stringBuilder.append("\n" + featureTooltip);
        }
        if (this.isReplayed()) {
            stringBuilder.append("\nThis frame is a replay of a previous frame.");
        }
        if (this.hasMidstreamTraceData()) {
            stringBuilder.append("\nThis frame contains a function that has API state/asset information attached to it as a result of attaching or reattaching to a process.");
        }
        return (String)NullUtils.neverNull((Object)stringBuilder.toString());
    }

    public int getApiCallCount() {
        return this.lastFunctionIndex - this.firstFunctionIndex + 1;
    }

    public int getInterestingCallCount() {
        int numInterestingCalls = 0;
        for (FrameRenderPass renderPass : this.getRenderPassList()) {
            numInterestingCalls += renderPass.getInterestingCallCount();
        }
        return numInterestingCalls;
    }

    public int getFirstFunctionIndex() {
        return this.firstFunctionIndex;
    }

    public int getLastFunctionIndex() {
        return this.lastFunctionIndex;
    }

    public boolean isCaptured() {
        for (FrameRenderPass renderPass : this.getRenderPassList()) {
            if (!renderPass.isCaptured()) continue;
            return true;
        }
        return false;
    }

    public List<FramebufferFeature> getFramebufferFeatures() {
        Set<@NonNull T> framebufferFeatures = this.getRenderPassList().stream().map(renderPass -> renderPass.getEnabledFeature()).collect(Collectors.toSet());
        ArrayList<@NonNull T> distinctFramebufferModes = new ArrayList(framebufferFeatures);
        distinctFramebufferModes.remove(FramebufferFeature.NOTHING);
        return this.getRenderPassList().isEmpty() ? Collections.emptyList() : distinctFramebufferModes;
    }

    public boolean isReplayed() {
        return this.replayed;
    }

    public void setReplayed(boolean value) {
        this.replayed = value;
    }

    public void setScreenshot(@NonNull ScreenshotAttachment screenshotAttachment) {
        this.screenshot = screenshotAttachment;
    }

    public @Nullable ScreenshotAttachment getScreenshot() {
        return this.screenshot;
    }

    public void setComplete(boolean complete) {
        if (complete) {
            this.calculatedReplayable = false;
        }
        this.complete = complete;
    }

    @Override
    public boolean isTheChildrenListFinal() {
        return this.complete || this.traceDataModel.isTheChildrenListFinal();
    }

    public boolean featuresEnabled() {
        return !this.getFramebufferFeatures().isEmpty();
    }

    public @NonNull TraceDataModel getParentModel() {
        return this.traceDataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable FrameRenderPass getRenderPassFor(@NonNull FunctionCall functionCall) {
        Map<GraphicsContext, List<FrameRenderPass>> map = this.perContextRenderPassMap;
        synchronized (map) {
            for (FrameRenderPass renderPass : this.renderPassList) {
                if (!renderPass.contains(functionCall)) continue;
                return renderPass;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull List<@NonNull FrameRenderPass> getRenderPassList() {
        Map<GraphicsContext, List<FrameRenderPass>> map = this.perContextRenderPassMap;
        synchronized (map) {
            return new ReadOnlySubList<FrameRenderPass>(this.renderPassList, 0, this.renderPassList.size());
        }
    }

    public @Nullable FrameRenderPass getFirstRenderPass() {
        return this.renderPassList.isEmpty() ? null : this.renderPassList.get(0);
    }

    @Override
    public @NonNull List<@NonNull FrameRenderPass> getChildren() {
        return this.getRenderPassList();
    }

    @Override
    public int compareTo(Frame o) {
        return Integer.compare(this.frameId, o.frameId);
    }

    public void setTotalMemoryAllocation(long newMemory) {
        this.totalMemoryAllocation += newMemory;
    }

    @Override
    public @NonNull Statistic getStatistic(@NonNull IStatisticType type) {
        if (type == CommonStatistics.NUMBER_OF_RENDER_PASSES) {
            return new Statistic(type, this.getRenderPassList().size());
        }
        if (type == CommonStatistics.TOTAL_MEMORY_ALLOCATIONS) {
            return new Statistic(type, this.totalMemoryAllocation);
        }
        return this.statisticsCache.getStat(type);
    }

    @Override
    public boolean hasDataForStatisticType(@NonNull IStatisticType type) {
        if (type == CommonStatistics.TOTAL_MEMORY_ALLOCATIONS) {
            return this.totalMemoryAllocation != 0L;
        }
        if (type == CommonStatistics.NUMBER_OF_RENDER_PASSES) {
            return true;
        }
        return this.statisticsCache.hasDataForStatisticType(type);
    }

    public boolean hasMidstreamTraceData() {
        return this.functionHasMidstreamTraceData;
    }

    public void setContainsLegacyCapture(@NonNull FramebufferFeature feature) {
        this.containsLegacyCapture = true;
        this.legacyFramebufferFeature = feature;
        for (FrameRenderPass frp : this.renderPassList) {
            if (frp.getCaptureMode() != FramebufferFeature.CaptureMode.NONE) continue;
            frp.setFramebufferFeature(feature);
        }
    }

    public boolean containsLegacyCapture() {
        return this.containsLegacyCapture;
    }

    public @NonNull FramebufferFeature getLegacyFramebufferFeature() {
        return this.legacyFramebufferFeature;
    }

    public int getId() {
        return this.frameId;
    }
}

