/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.ArrayArgumentAttachment;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FloatsArgAttachment
extends ArrayArgumentAttachment<Float> {
    private static final long serialVersionUID = 5718088533402055511L;
    private static final float @NonNull [] EMPTY_FLOATS = new float[0];
    private static final @NonNull WeakHashMap<FloatArrayWrapper, @Nullable WeakReference<float @Nullable []>> VALUES_CACHE = new WeakHashMap();
    private final float @NonNull [] floats;

    public static @NonNull FloatsArgAttachment create(List<Float> floatsList) {
        assert (floatsList != null);
        assert (NullUtils.isCollectionNonNull(floatsList));
        return new FloatsArgAttachment(floatsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatsArgAttachment(@NonNull List<@NonNull Float> floatsList) {
        if (floatsList.size() == 0) {
            this.floats = EMPTY_FLOATS;
        } else {
            float[] cachedFloats;
            float @NonNull [] array = new float[floatsList.size()];
            int i = 0;
            while (i < array.length) {
                array[i] = floatsList.get(i).floatValue();
                ++i;
            }
            FloatArrayWrapper wrapper = new FloatArrayWrapper(array);
            WeakHashMap<FloatArrayWrapper, WeakReference<float[]>> weakHashMap = VALUES_CACHE;
            synchronized (weakHashMap) {
                WeakReference<float @Nullable []> cachedListRef = VALUES_CACHE.get(wrapper);
                float[] fArray = cachedFloats = cachedListRef == null ? null : (float[])cachedListRef.get();
                if (cachedFloats == null) {
                    cachedFloats = array;
                    VALUES_CACHE.put(wrapper, new WeakReference<float[]>(array));
                }
            }
            this.floats = cachedFloats;
        }
    }

    @Override
    public @NonNull Float get(int index) {
        return NullUtils.floatValueOf((float)this.floats[index]);
    }

    public float getFloat(int index) {
        return this.floats[index];
    }

    @Override
    public Iterator<@NonNull Float> iterator() {
        return this.asList().iterator();
    }

    @Override
    public @NonNull List<@NonNull Float> asList() {
        ArrayList<@NonNull Float> list = new ArrayList<Float>(this.floats.length);
        float[] fArray = this.floats;
        int n = this.floats.length;
        int n2 = 0;
        while (n2 < n) {
            float l = fArray[n2];
            list.add(NullUtils.floatValueOf((float)l));
            ++n2;
        }
        return list;
    }

    @Override
    public int size() {
        return this.floats.length;
    }

    public int hashCode() {
        return this.floats.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FloatsArgAttachment) {
            FloatsArgAttachment other = (FloatsArgAttachment)obj;
            return Arrays.equals(this.floats, other.floats);
        }
        return false;
    }

    @Override
    public @NonNull String getDescriptiveText() {
        if (this.isNull()) {
            return "NULL";
        }
        return (String)NullUtils.neverNull((Object)Arrays.toString(this.floats));
    }

    @Override
    public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
        if (this.isNull()) {
            return ArgumentHierarchyLeaf.nullPointer(this.getArgumentName());
        }
        ArrayList<@NonNull ArgumentHierarchyNode> elementList = new ArrayList<ArgumentHierarchyNode>(this.size());
        for (Float floatValue : this) {
            elementList.add(new ArgumentHierarchyLeaf((String)NullUtils.neverNull((Object)floatValue.toString()), ArgumentHierarchyLeaf.LeafType.FLOAT));
        }
        return ArgumentHierarchyBranch.arrayHierarchy(this.getArgumentName(), elementList);
    }

    private static class FloatArrayWrapper {
        private final float @NonNull [] floats;

        private FloatArrayWrapper(float @NonNull [] floats) {
            this.floats = floats;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FloatArrayWrapper) {
                return Arrays.equals(this.floats, ((FloatArrayWrapper)obj).floats);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.floats);
        }
    }
}

