/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.target.data.IMemoryRegionAttachment;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class EmulatedVulkanDeviceMemoryContents
implements IMemoryRegionAttachment {
    private static final long serialVersionUID = -2125784555034900463L;
    private final @NonNull VkDeviceMemoryAsset source;
    private final long sourceOffset;
    private final long sourceMemoryHistoryIndex;
    private final long destinationDeviceID;
    private final long destinationMemoryID;
    private final long destinationOffset;
    private final int size;

    public EmulatedVulkanDeviceMemoryContents(@NonNull VkDeviceMemoryAsset source, long sourceOffset, long destinationDevice, long destinationMemory, long destinationOffset, int size) {
        this.source = source;
        this.sourceOffset = sourceOffset;
        this.sourceMemoryHistoryIndex = source.getMemoryRegionHistory().size();
        this.destinationDeviceID = destinationDevice;
        this.destinationMemoryID = destinationMemory;
        this.destinationOffset = destinationOffset;
        this.size = size;
    }

    public long getDevice() {
        return this.destinationDeviceID;
    }

    public long getMemory() {
        return this.destinationMemoryID;
    }

    @Override
    public long getOffset() {
        return this.destinationOffset;
    }

    @Override
    public @NonNull IByteDataProvider getDataForRegion() {
        byte @NonNull [] returnVal = new byte[this.size];
        @NonNull List<@NonNull IMemoryRegionAttachment> regions = this.source.getMemoryRegionHistory();
        int i = 0;
        while ((long)i < this.sourceMemoryHistoryIndex) {
            regions.get(i).copyIntoByteArray(this.sourceOffset, returnVal);
            ++i;
        }
        return IByteDataProvider.createMemoryProvider(returnVal);
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

