/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.target.data.IMemoryRegionAttachment;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import org.eclipse.jdt.annotation.NonNull;

public class EmulatedClMemoryRegionAttachment
implements IMemoryRegionAttachment {
    private static final long serialVersionUID = -2317118264094246099L;
    private final long dstOffset;
    private final long srcOffset;
    private final int size;
    private final @NonNull ClMemoryAsset parent;
    private final int parentIndex;

    public EmulatedClMemoryRegionAttachment(long dstOffset, long srcOffset, int size, @NonNull ClMemoryAsset parent) {
        this.dstOffset = dstOffset;
        this.srcOffset = srcOffset;
        this.size = size;
        this.parent = parent;
        this.parentIndex = parent.getCurrentAttachmentIndex();
    }

    @Override
    public long getOffset() {
        return this.dstOffset;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public @NonNull IByteDataProvider getDataForRegion() {
        byte[] source = this.parent.getDataFromAttachments(this.parentIndex);
        byte[] returnVal = new byte[this.getSize()];
        System.arraycopy(source, (int)this.srcOffset, returnVal, (int)this.dstOffset, this.getSize());
        return IByteDataProvider.createMemoryProvider(returnVal);
    }

    public long getSourceOffset() {
        return this.srcOffset;
    }

    public @NonNull ClMemoryAsset getParent() {
        return this.parent;
    }
}

