/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.EglConfigAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.EGLAttributeAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EGLConfigAttributeArrayAttachment
extends AbstractFreeAttachment {
    private static final long serialVersionUID = -1345351114524318241L;
    private final long id;
    private final @NonNull List<@NonNull EGLAttributeAttachment> attributes;

    public EGLConfigAttributeArrayAttachment(long id, @NonNull List<@NonNull EGLAttributeAttachment> attributes) {
        this.id = id;
        this.attributes = attributes;
    }

    private @NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> getConfigAttributes() {
        return this.attributes.stream().collect(Collectors.toMap(att -> KapiSpec.EGL.constantGroups.CONFIG_ATTRIBUTES.getConstantSpecByValue(att.getKey()), att -> att.getValue()));
    }

    private @Nullable EglConfigAsset getConfigAssetFromSnapshot(@NonNull TraceStateSnapshot state) {
        AssetTable table = state.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS.SPEC);
        IAssetItem configAsset = table.get((Long)this.id);
        if (configAsset instanceof EglConfigAsset) {
            return (EglConfigAsset)configAsset;
        }
        return null;
    }

    @Override
    public void process(@NonNull TraceStateSnapshot currentState) {
        EglConfigAsset asset = this.getConfigAssetFromSnapshot(currentState);
        if (asset != null) {
            asset.setAttributesCollection(this.getConfigAttributes());
        }
    }

    public long getConfigId() {
        return this.id;
    }

    public final @NonNull List<@NonNull EGLAttributeAttachment> getAttributes() {
        return this.attributes;
    }
}

