/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.util.ICoreProgressMonitor;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;

public class CompletableProgressFuture<T>
extends CompletableFuture<T>
implements ICoreProgressMonitor,
Serializable {
    private static final long serialVersionUID = -8081519141840846894L;
    private boolean cancelled;
    private final Set<ICoreProgressMonitor> monitors = new CopyOnWriteArraySet<ICoreProgressMonitor>();
    private String name;
    private int totalWork;
    private int workDone;

    public static <U> @NonNull CompletableProgressFuture<U> supplyAsync(Executor e, Function<@NonNull ICoreProgressMonitor, U> f) {
        if (e == null || f == null) {
            throw new NullPointerException();
        }
        CompletableProgressFuture result = new CompletableProgressFuture();
        e.execute(new AsyncSupply(result, f));
        return result;
    }

    public void addMonitor(ICoreProgressMonitor monitor) {
        this.monitors.add(monitor);
        monitor.setTask(this.name, this.totalWork - this.workDone);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = super.cancel(mayInterruptIfRunning);
        this.cancelled |= result;
        return result;
    }

    public int getProgress() {
        return this.workDone;
    }

    @Override
    public void incProgress(int n) {
        this.workDone += n;
        this.notifyMonitorsIncProgress(n);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setTask(String name, int totalWork) {
        this.name = name;
        this.totalWork = totalWork;
        this.workDone = 0;
        this.notifyMonitorsSetTask();
    }

    private void notifyMonitorsIncProgress(int progress) {
        for (ICoreProgressMonitor monitor : this.monitors) {
            monitor.incProgress(progress);
        }
    }

    private void notifyMonitorsSetTask() {
        for (ICoreProgressMonitor monitor : this.monitors) {
            monitor.setTask(this.name, this.totalWork - this.workDone);
        }
    }

    private static final class AsyncSupply<T>
    implements Runnable {
        private final @NonNull CompletableProgressFuture<T> dep;
        private final @NonNull Function<@NonNull ICoreProgressMonitor, T> fn;

        AsyncSupply(@NonNull CompletableProgressFuture<T> dep, @NonNull Function<@NonNull ICoreProgressMonitor, T> fn) {
            this.dep = dep;
            this.fn = fn;
        }

        @Override
        public void run() {
            if (!this.dep.isDone()) {
                try {
                    this.dep.complete(this.fn.apply(this.dep));
                }
                catch (Throwable e) {
                    this.dep.completeExceptionally(e);
                }
            }
        }
    }
}

