/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.InterestingFunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallDescriptor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.gen.ClEnqueueCallInfoSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClEnqueueCall
extends InterestingFunctionCall {
    private static final long serialVersionUID = 7191359652786174007L;

    public ClEnqueueCall(int index, @NonNull FunctionCallDescriptor functionCallDescriptor, @NonNull TraceDataModel model) {
        super(index, functionCallDescriptor, model);
        assert (functionCallDescriptor.getFunctionSpec().isClEnqueueCall());
    }

    public @Nullable Pointer getCommandQueue() {
        @NonNull ClEnqueueCallInfoSpec spec = (ClEnqueueCallInfoSpec)NullUtils.neverNull((Object)this.getFunctionSpec().getClEnqueueCallInfo());
        @Nullable ArgumentSpec commandQueueSpec = spec.getCommandQueueArg();
        if (commandQueueSpec == null) {
            return null;
        }
        Serializable commandQueue = this.getArgValue(commandQueueSpec.getArgIndex());
        assert (commandQueue instanceof Pointer);
        return (Pointer)commandQueue;
    }

    public boolean canBlock() {
        @NonNull ClEnqueueCallInfoSpec spec = (ClEnqueueCallInfoSpec)NullUtils.neverNull((Object)this.getFunctionSpec().getClEnqueueCallInfo());
        if (spec.getIsAlwaysBlocking()) {
            return true;
        }
        return spec.getBlockingArg() != null;
    }

    public boolean isBlocking() {
        @NonNull ClEnqueueCallInfoSpec spec = (ClEnqueueCallInfoSpec)NullUtils.neverNull((Object)this.getFunctionSpec().getClEnqueueCallInfo());
        if (spec.getIsAlwaysBlocking()) {
            return true;
        }
        @Nullable ArgumentSpec blockingSpec = spec.getBlockingArg();
        if (blockingSpec == null) {
            return false;
        }
        Serializable blockingArg = this.getArgValue(blockingSpec.getArgIndex());
        assert (blockingArg instanceof AbstractConstantOrAliasSpecExtended);
        return blockingArg.equals(KapiSpec.CL.constants.CL_TRUE);
    }

    public @Nullable List<@NonNull Pointer> getEventWaitList() {
        @NonNull ClEnqueueCallInfoSpec spec = (ClEnqueueCallInfoSpec)NullUtils.neverNull((Object)this.getFunctionSpec().getClEnqueueCallInfo());
        @Nullable ArgumentSpec waitListSpec = spec.getEventWaitListArg();
        if (waitListSpec == null) {
            return null;
        }
        Serializable waitListArg = this.getArgValue(waitListSpec.getArgIndex());
        assert (waitListArg instanceof LongsArgAttachment);
        LongsArgAttachment waitListAttachment = (LongsArgAttachment)waitListArg;
        ArrayList<@NonNull Pointer> waitList = new ArrayList<Pointer>();
        Iterator iterator = waitListAttachment.iterator();
        while (iterator.hasNext()) {
            long event = (Long)iterator.next();
            waitList.add(Pointer.valueOf(event));
        }
        return waitList;
    }

    public boolean canHaveEvent() {
        @NonNull ClEnqueueCallInfoSpec spec = (ClEnqueueCallInfoSpec)NullUtils.neverNull((Object)this.getFunctionSpec().getClEnqueueCallInfo());
        return spec.getEventArg() != null;
    }

    public @Nullable Pointer getEvent() {
        @NonNull ClEnqueueCallInfoSpec spec = (ClEnqueueCallInfoSpec)NullUtils.neverNull((Object)this.getFunctionSpec().getClEnqueueCallInfo());
        @Nullable ArgumentSpec eventSpec = spec.getEventArg();
        if (eventSpec == null) {
            return null;
        }
        Serializable eventArg = this.getArgValue(eventSpec.getArgIndex());
        if (eventArg instanceof LongPtrArgAttachment) {
            return Pointer.valueOf(((LongPtrArgAttachment)eventArg).getValue());
        }
        return null;
    }
}

