/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IFunctionCallModelListener;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.WeakListenerSet;
import com.arm.mgd.utils.NullUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BookmarkModel {
    private static final @NonNull Bookmark EMPTY_BOOKMARK = new Bookmark("");
    private static final long MINIMUM_LISTENER_NOTIFY_PERIOD_MILLIS = 500L;
    private final @NonNull TraceDataModel model;
    private final @NonNull ReentrantReadWriteLock bookmarksLock = new ReentrantReadWriteLock();
    private final @NonNull Map<@NonNull FunctionCall, @Nullable Bookmark> bookmarks = new TreeMap<FunctionCall, Bookmark>();
    private final @NonNull AtomicBoolean haveBookmarksChangedSinceLastBatch = new AtomicBoolean(false);
    private long lastListenerNotifyTimeMillis = 0L;
    private final @NonNull Map<@NonNull FunctionCall, @Nullable Bookmark> bookmarkChangesSinceLastBatch = new LinkedHashMap<FunctionCall, Bookmark>();
    private final @NonNull WeakListenerSet<IBookmarkChangeListener> listeners = new WeakListenerSet();

    public BookmarkModel(@NonNull TraceDataModel model) {
        this.model = model;
        final ScheduledFuture<?> future = CoreInstance.getScheduledExecutorService().scheduleWithFixedDelay(() -> this.onBatchTimerTick(), 0L, 16L, TimeUnit.MILLISECONDS);
        model.addListener(new IFunctionCallModelListener(){

            @Override
            public void onFunctionCallModelComplete(@NonNull TraceDataModel completedModel) {
            }

            @Override
            public void onFunctionCallModelClose(@NonNull TraceDataModel closingModel, @NonNull ICoreProgressMonitor monitor) {
                future.cancel(false);
            }
        });
    }

    public @Nullable Bookmark getBookmark(@NonNull FunctionCall functionCall) {
        assert (functionCall.getModel().equals(this.model));
        ReentrantReadWriteLock.ReadLock readLock = this.bookmarksLock.readLock();
        try {
            readLock.lock();
            Bookmark bookmark = this.bookmarks.get(functionCall);
            return bookmark;
        }
        finally {
            readLock.unlock();
        }
    }

    public void addBookmark(@NonNull FunctionCall functionCall, @NonNull String note) {
        @NonNull Bookmark bookmark = note.isEmpty() ? EMPTY_BOOKMARK : new Bookmark(note);
        this.setBookmark(functionCall, bookmark);
    }

    public void removeBookmark(@NonNull FunctionCall functionCall) {
        this.setBookmark(functionCall, null);
    }

    private void setBookmark(@NonNull FunctionCall fc, @Nullable Bookmark bookmark) {
        assert (fc.getModel() == this.model);
        ReentrantReadWriteLock.WriteLock writeLock = this.bookmarksLock.writeLock();
        try {
            writeLock.lock();
            @Nullable Bookmark oldBookmark = bookmark == null ? this.bookmarks.remove(fc) : this.bookmarks.put(fc, bookmark);
            if (!Objects.equals(bookmark, oldBookmark)) {
                this.bookmarkChangesSinceLastBatch.put(fc, bookmark);
                this.haveBookmarksChangedSinceLastBatch.set(true);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void addEmptyBookmarks(@NonNull Collection<@NonNull FunctionCall> functionCalls) {
        ReentrantReadWriteLock.WriteLock writeLock = this.bookmarksLock.writeLock();
        try {
            writeLock.lock();
            boolean modified = false;
            for (FunctionCall fc : functionCalls) {
                assert (fc.getModel() == this.model);
                Bookmark existingBookmark = this.bookmarks.putIfAbsent(fc, EMPTY_BOOKMARK);
                if (existingBookmark != null) continue;
                modified = true;
                this.bookmarkChangesSinceLastBatch.put(fc, EMPTY_BOOKMARK);
            }
            if (modified) {
                this.haveBookmarksChangedSinceLastBatch.set(true);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void removeBookmarks(@NonNull Collection<@NonNull FunctionCall> functionCalls) {
        ReentrantReadWriteLock.WriteLock writeLock = this.bookmarksLock.writeLock();
        try {
            writeLock.lock();
            boolean modified = false;
            for (FunctionCall fc : functionCalls) {
                assert (fc.getModel() == this.model);
                @Nullable Bookmark oldBookmark = this.bookmarks.remove(fc);
                if (oldBookmark == null) continue;
                modified = true;
                this.bookmarkChangesSinceLastBatch.put(fc, null);
            }
            if (modified) {
                this.haveBookmarksChangedSinceLastBatch.set(true);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void onBatchTimerTick() {
        if (!this.haveBookmarksChangedSinceLastBatch.get()) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastListenerNotifyTimeMillis < 500L) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.bookmarksLock.writeLock();
        try {
            writeLock.lock();
            @NonNull @Nullable Map changeCopy = (Map)NullUtils.neverNull(Collections.unmodifiableMap(new HashMap<FunctionCall, Bookmark>(this.bookmarkChangesSinceLastBatch)));
            class BooleanWrapper {
                boolean value = true;

                BooleanWrapper() {
                }
            }
            BooleanWrapper allChangesConsumed = new BooleanWrapper();
            this.listeners.notifyWeakListeners(listener -> {
                boolean bl = booleanWrapper.value = booleanWrapper.value & listener.onBookmarksChange(this.model, changeCopy);
            });
            if (allChangesConsumed.value) {
                this.haveBookmarksChangedSinceLastBatch.set(false);
                this.bookmarkChangesSinceLastBatch.clear();
            }
            this.lastListenerNotifyTimeMillis = currentTimeMillis;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void addListener(@Nullable BiConsumer<@NonNull FunctionCall, @NonNull Bookmark> forEachBookmark, @NonNull IBookmarkChangeListener listener) {
        ReentrantReadWriteLock.ReadLock readLock = this.bookmarksLock.readLock();
        try {
            readLock.lock();
            if (forEachBookmark != null) {
                this.bookmarks.forEach(forEachBookmark);
            }
            this.listeners.addListenerAsWeakReference(listener);
        }
        finally {
            readLock.unlock();
        }
    }

    public void removeListener(@NonNull IBookmarkChangeListener listener) {
        this.listeners.removeWeakReference(listener);
    }

    public static class Bookmark {
        private final @NonNull String note;

        private Bookmark(@NonNull String note) {
            this.note = note;
        }

        public @NonNull String getNote() {
            return this.note;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bookmark) {
                return this.note.equals(((Bookmark)obj).note);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.note);
        }
    }

    public static interface IBookmarkChangeListener {
        public boolean onBookmarksChange(@NonNull TraceDataModel var1, @NonNull Map<@NonNull FunctionCall, @Nullable Bookmark> var2);
    }
}

