/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.IAutomatedTraceCommandListener;
import com.arm.mgd.core.util.WeakListenerSet;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;

public class AutomatedTraceCommandManager {
    private final @NonNull ArrayList<AutomatedTraceCommand> automatedTraceCommands = new ArrayList();
    private final @NonNull WeakListenerSet<IAutomatedTraceCommandListener> listeners = new WeakListenerSet();

    public final @NonNull ArrayList<AutomatedTraceCommand> getAutomatedTraceCommands() {
        return this.automatedTraceCommands;
    }

    public boolean containsCommandForFrame(int frameNumber) {
        for (AutomatedTraceCommand automatedTraceCommand : this.automatedTraceCommands) {
            if (automatedTraceCommand.getFrameNumber() != frameNumber) continue;
            return true;
        }
        return false;
    }

    public void addAutomatedCommand(AutomatedTraceCommand atc) {
        this.automatedTraceCommands.add(atc);
        this.listeners.notifyWeakListeners(listener -> listener.automatedTraceCommandsChanged(this.getAutomatedTraceCommands()));
    }

    public void addListener(@NonNull IAutomatedTraceCommandListener listener) {
        this.listeners.addListenerAsWeakReference(listener);
        listener.automatedTraceCommandsChanged(this.automatedTraceCommands);
    }

    public void removeListener(@NonNull IAutomatedTraceCommandListener listener) {
        this.listeners.removeWeakReference(listener);
    }

    public void deleteAutomatedCommand(AutomatedTraceCommand atc) {
        this.automatedTraceCommands.remove(atc);
        this.listeners.notifyWeakListeners(listener -> listener.automatedTraceCommandsChanged(this.getAutomatedTraceCommands()));
    }

    protected void clearCommands() {
        this.automatedTraceCommands.clear();
        this.listeners.notifyWeakListeners(listener -> listener.automatedTraceCommandsChanged(this.getAutomatedTraceCommands()));
    }
}

