/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.DeferredCommandItem;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.target.io.live.PerProcessInterceptorCommand;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class AutomatedTraceCommand {
    private @NonNull AutomatedCommandType commandType;
    private final int frameNumber;

    public AutomatedTraceCommand(@NonNull AutomatedCommandType commandType, int frameNumber) {
        this.commandType = commandType;
        this.frameNumber = frameNumber;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public @NonNull AutomatedCommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(@NonNull AutomatedCommandType type) {
        this.commandType = type;
    }

    public String toString() {
        return String.valueOf(this.commandType.getDescription()) + ": " + this.frameNumber;
    }

    public static enum AutomatedCommandType {
        FRAME_CAPTURE("Capture frame", new DeferredCommandItem(ModifyStateInterceptorCommand.ALL_DISABLED, 0), new DeferredCommandItem(PerProcessInterceptorCommand.FRAME_CAPTURE, 0)),
        OVERDRAW_CAPTURE("Capture frame with Overdraw mode enabled (OpenGL ES only)", new DeferredCommandItem(ModifyStateInterceptorCommand.OVERDRAW_ENABLED, 0), new DeferredCommandItem(PerProcessInterceptorCommand.FRAME_CAPTURE, 0)),
        ALL_ATTACHMENTS_CAPTURE("Capture frame with All Attachments mode enabled (OpenGL ES only)", new DeferredCommandItem(ModifyStateInterceptorCommand.ALLATTACHMENTSMODE_ENABLED, 0), new DeferredCommandItem(PerProcessInterceptorCommand.FRAME_CAPTURE, 0)),
        SHADER_MAP_CAPTURE("Capture frame with Shadermap mode enabled (OpenGL ES only)", new DeferredCommandItem(ModifyStateInterceptorCommand.SHADERMAP_ENABLED, 0), new DeferredCommandItem(PerProcessInterceptorCommand.FRAME_CAPTURE, 0)),
        FRAGMENT_COUNT_CAPTURE("Enable fragment count mode for frame (OpenGL ES only)", new DeferredCommandItem(ModifyStateInterceptorCommand.FRAGMENTCOUNT_ENABLED, 0), new DeferredCommandItem(PerProcessInterceptorCommand.FRAME_CAPTURE, 0)),
        PAUSE("Pause the current process before frame", new DeferredCommandItem(PerProcessInterceptorCommand.PAUSE_ON_FRAME_END, 0)),
        TERMINATE("Disconnect from the current process before frame", new DeferredCommandItem(PerProcessInterceptorCommand.DISCONNECT, 0));

        private final @NonNull String description;
        private final @NonNull List<DeferredCommandItem> commandBundle;

        private AutomatedCommandType(String description, DeferredCommandItem ... commandBundle) {
            this.description = description;
            this.commandBundle = NullUtils.asList((Object[])commandBundle);
        }

        public List<DeferredCommandItem> getCommandBundle() {
            return this.commandBundle;
        }

        public @NonNull String getDescription() {
            return this.description;
        }
    }
}

