/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class AttachmentClearStatus {
    private final @NonNull Set<AbstractConstantOrAliasSpecExtended> colourAttachmentsCleared = new HashSet<AbstractConstantOrAliasSpecExtended>();
    private boolean depthAttachmentCleared = false;
    private boolean stencilAttachmentCleared = false;

    public void addDrawBufferCleared(Integer drawBuffer, @NonNull Long attachmentId) {
        AbstractConstantOrAliasSpecExtended colourAttachmentToAdd;
        if (attachmentId == 0L) {
            assert (drawBuffer == 0) : "glClearBuffers called on FB0 whith a non-zero (" + drawBuffer + ") draw buffer";
            colourAttachmentToAdd = KapiSpec.GLES.constants.GL_BACK;
        } else {
            Long colourAttachmentZero = KapiSpec.GLES.constants.GL_COLOR_ATTACHMENT0.getResolvedValue();
            colourAttachmentToAdd = KapiSpec.GLES.getConstantSpecByValue(NullUtils.longValueOf((long)(colourAttachmentZero + (long)drawBuffer.intValue())));
        }
        assert (colourAttachmentToAdd != null);
        this.colourAttachmentsCleared.add(colourAttachmentToAdd);
    }

    public void setDepthCleared() {
        this.depthAttachmentCleared = true;
    }

    public void setStencilCleared() {
        this.stencilAttachmentCleared = true;
    }

    public void addColourAttachmentsCleared(@NonNull Collection<AbstractConstantOrAliasSpecExtended> colourAttachments) {
        this.colourAttachmentsCleared.addAll(colourAttachments);
    }

    public boolean isCleared(@NonNull AbstractConstantOrAliasSpecExtended attachment) {
        if (attachment.equals(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT)) {
            return this.depthAttachmentCleared;
        }
        if (attachment.equals(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT)) {
            return this.stencilAttachmentCleared;
        }
        return this.colourAttachmentsCleared.contains(attachment);
    }
}

