/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.AsynchronousFunctionAttachment;
import com.arm.mgd.core.target.data.IAsynchronousDataListener;
import com.arm.mgd.core.target.data.VulkanImageCompositor;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ListenerList;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AsynchronousDataModel {
    private final @NonNull Set<Integer> asynchronousFunctionIDWaitingSet = new HashSet<Integer>(0);
    private final @NonNull Map<Integer, ArrayList<@NonNull AsynchronousFunctionAttachment>> asynchronousFunctionIDToAttachmentMap = new ConcurrentHashMap<Integer, ArrayList<AsynchronousFunctionAttachment>>(0);
    private final @NonNull ListenerList<IAsynchronousDataListener> asynchronousDataListeners = new ListenerList();
    private final @NonNull VulkanImageCompositor vulkanImageCompositor = new VulkanImageCompositor();

    public void addListener(@NonNull IAsynchronousDataListener listener) {
        this.asynchronousDataListeners.add(listener);
    }

    public void removeListener(@NonNull IAsynchronousDataListener listener) {
        this.asynchronousDataListeners.remove(listener);
    }

    public void addFunctionUIDToWaitingSet(@Nullable Integer asynchronousFunctionCallUid) {
        boolean noPreviousEntry = this.asynchronousFunctionIDWaitingSet.add(asynchronousFunctionCallUid);
        assert (noPreviousEntry) : "Duplicate function calls recieved with the same asynchronous UID (" + asynchronousFunctionCallUid + ")";
        this.asynchronousFunctionIDToAttachmentMap.put(asynchronousFunctionCallUid, new ArrayList());
    }

    public void addAsynchronousAssetData(@NonNull Integer functionCallUID, @NonNull AsynchronousFunctionAttachment assetData) {
        if (!this.asynchronousFunctionIDWaitingSet.contains(functionCallUID)) {
            CoreLogging.warning(null, "Asynchronous asset data recieved when it was not expected.");
            return;
        }
        assetData.process(this);
        ((ArrayList)NullUtils.neverNull(this.asynchronousFunctionIDToAttachmentMap.get(functionCallUID))).add(assetData);
        this.notifyListeners(functionCallUID, assetData);
    }

    private void notifyListeners(@NonNull Integer functionCallUID, @NonNull AsynchronousFunctionAttachment assetData) {
        for (IAsynchronousDataListener listener : this.asynchronousDataListeners) {
            listener.dataArrived(functionCallUID, assetData);
        }
    }

    public boolean hasAsynchronousAssetData() {
        return this.asynchronousFunctionIDToAttachmentMap.size() != 0;
    }

    public @NonNull List<@NonNull AsynchronousFunctionAttachment> getAsynchronousAssetData(@NonNull Integer functionCallUID) {
        ArrayList<@NonNull AsynchronousFunctionAttachment> existingData = this.asynchronousFunctionIDToAttachmentMap.get(functionCallUID);
        if (existingData == null) {
            return NullUtils.EMPTY_LIST;
        }
        return new ReadOnlySubList<AsynchronousFunctionAttachment>(existingData);
    }

    public @NonNull Map<Integer, List<@NonNull AsynchronousFunctionAttachment>> getAsynchronousAssetData() {
        HashMap<Integer, ReadOnlySubList<@NonNull T>> copy = new HashMap();
        for (Map.Entry<Integer, ArrayList<AsynchronousFunctionAttachment>> i : this.asynchronousFunctionIDToAttachmentMap.entrySet()) {
            copy.put(i.getKey(), new ReadOnlySubList(NullUtils.neverNullList((List)i.getValue())));
        }
        return (Map)NullUtils.neverNull(Collections.unmodifiableMap(copy));
    }

    public @NonNull VulkanImageCompositor getVulkanImageCompositor() {
        return this.vulkanImageCompositor;
    }
}

