/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ArgumentHierarchyLeaf
extends ArgumentHierarchyNode {
    private final @NonNull String value;
    private final @NonNull LeafType type;

    public ArgumentHierarchyLeaf(@NonNull String value, @NonNull LeafType type) {
        this(null, value, type);
    }

    public ArgumentHierarchyLeaf(@Nullable String name, @NonNull String value, @NonNull LeafType type) {
        super(name);
        this.value = value;
        this.type = type;
    }

    public static @NonNull ArgumentHierarchyNode nullPointer(@NonNull String name) {
        return new ArgumentHierarchyLeaf(name, "NULL", LeafType.ENUM);
    }

    public @NonNull String getValue() {
        return this.value;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    protected void printFullHierarchy(@NonNull StringBuilder sb) {
        String argumentName = this.getName();
        if (argumentName != null) {
            sb.append(argumentName).append('=');
        }
        if (this.type == LeafType.STRING) {
            sb.append('\"').append(this.getValue()).append('\"');
        } else {
            sb.append(this.getValue());
        }
    }

    public @NonNull LeafType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printFullHierarchy(sb);
        return sb.toString();
    }

    @Override
    public void accept(@NonNull ArgumentHierarchyNode.IArgumentHierarchyVisitor visitor) {
        visitor.visit(this);
    }

    public static enum LeafType {
        STRING,
        INTEGER,
        FLOAT,
        ENUM,
        POINTER;

    }
}

