/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;

public class ArgumentHierarchyFactory {
    public static @NonNull ArgumentHierarchyNode createFromSerializable(@NonNull String name, @NonNull Serializable value) {
        @NonNull String stringValue = (String)NullUtils.neverNull((Object)value.toString());
        if (value instanceof Integer) {
            return new ArgumentHierarchyLeaf(name, stringValue, ArgumentHierarchyLeaf.LeafType.INTEGER);
        }
        if (value instanceof Long) {
            return new ArgumentHierarchyLeaf(name, stringValue, ArgumentHierarchyLeaf.LeafType.INTEGER);
        }
        if (value instanceof Float) {
            return new ArgumentHierarchyLeaf(name, stringValue, ArgumentHierarchyLeaf.LeafType.FLOAT);
        }
        if (value instanceof Pointer) {
            Pointer pointer = (Pointer)value;
            if (Pointer.NULL.equals(pointer)) {
                return new ArgumentHierarchyLeaf(name, "NULL", ArgumentHierarchyLeaf.LeafType.ENUM);
            }
            return new ArgumentHierarchyLeaf(name, stringValue, ArgumentHierarchyLeaf.LeafType.POINTER);
        }
        if (value instanceof AbstractConstantOrAliasSpecExtended) {
            return new ArgumentHierarchyLeaf(name, stringValue, ArgumentHierarchyLeaf.LeafType.ENUM);
        }
        if (value instanceof Bitfield) {
            Bitfield bitfield = (Bitfield)value;
            ArrayList<@NonNull ArgumentHierarchyNode> elementList = new ArrayList<ArgumentHierarchyNode>(bitfield.size());
            for (AbstractConstantOrAliasSpecExtended constantSpec : bitfield) {
                elementList.add(new ArgumentHierarchyLeaf((String)NullUtils.neverNull((Object)constantSpec.toString()), ArgumentHierarchyLeaf.LeafType.ENUM));
            }
            return ArgumentHierarchyBranch.bitfieldHierarchy(name, elementList);
        }
        if (value instanceof Handle) {
            return new ArgumentHierarchyLeaf(name, stringValue, ArgumentHierarchyLeaf.LeafType.POINTER);
        }
        throw new IllegalArgumentException("Value of type " + value.getClass() + " is not handled.");
    }
}

