/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ArgumentHierarchyBranch
extends ArgumentHierarchyNode {
    private final @NonNull List<@NonNull ArgumentHierarchyNode> children;
    private final @NonNull BranchType type;

    private ArgumentHierarchyBranch(@NonNull String name, @NonNull List<@NonNull ArgumentHierarchyNode> children, @NonNull BranchType type) {
        super(name);
        this.children = children;
        this.type = type;
    }

    public static @NonNull ArgumentHierarchyBranch functionHierarchy(@NonNull String name, @NonNull List<@NonNull ArgumentHierarchyNode> arguments) {
        return new ArgumentHierarchyBranch(name, arguments, BranchType.FUNCTION);
    }

    public static @NonNull ArgumentHierarchyBranch structHierarchy(@NonNull String name, @NonNull List<@NonNull ArgumentHierarchyNode> members) {
        return new ArgumentHierarchyBranch(name, members, BranchType.STRUCT);
    }

    public static @NonNull ArgumentHierarchyBranch arrayHierarchy(@NonNull String name, @NonNull List<@NonNull ArgumentHierarchyNode> elements) {
        return new ArgumentHierarchyBranch(name, elements, BranchType.ARRAY);
    }

    public static @NonNull ArgumentHierarchyBranch bitfieldHierarchy(@NonNull String name, @NonNull List<@NonNull ArgumentHierarchyNode> fields) {
        return new ArgumentHierarchyBranch(name, fields, BranchType.BITFIELD);
    }

    public @NonNull List<@NonNull ArgumentHierarchyNode> getChildren() {
        return this.children;
    }

    public @NonNull BranchType getType() {
        return this.type;
    }

    @Override
    protected void printFullHierarchy(@NonNull StringBuilder sb) {
        sb.append(this.getName());
        if (this.getType().childrenAreAssigned()) {
            sb.append("=");
        }
        List<@NonNull ArgumentHierarchyNode> arguments = this.getChildren();
        sb.append(this.type.getOpenHierarchy());
        int i = 0;
        while (i < arguments.size()) {
            if (i > 0) {
                sb.append(this.type.getChildrenSeparator());
            }
            ArgumentHierarchyNode argument = arguments.get(i);
            argument.printFullHierarchy(sb);
            ++i;
        }
        sb.append(this.type.getCloseHierarchy());
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printFullHierarchy(sb);
        return sb.toString();
    }

    @Override
    public void accept(@NonNull ArgumentHierarchyNode.IArgumentHierarchyVisitor visitor) {
        visitor.visitBranch(this);
        List<@NonNull ArgumentHierarchyNode> arguments = this.getChildren();
        int i = 0;
        while (i < arguments.size()) {
            arguments.get(i).accept(visitor);
            if (i != arguments.size() - 1) {
                visitor.betweenBranchChildren(this);
            }
            ++i;
        }
        visitor.leaveBranch(this);
    }

    public static enum BranchType {
        FUNCTION('(', ')', ", ", "argument", "arguments", false),
        STRUCT('{', '}', ", ", "member", "members", true),
        ARRAY('[', ']', ", ", "element", "elements", true),
        BITFIELD('<', '>', " | ", "field", "fields", true);

        private final char openHierarchy;
        private final char closeHierarchy;
        private final @NonNull String childrenSeparator;
        private final @NonNull String singularChildName;
        private final @NonNull String pluralChildName;
        private final boolean childrenAreAssigned;

        private BranchType(@NonNull char openHierarchy, @NonNull char closeHierarchy, @NonNull String memberSeparator, String singularChildName, String pluralChildName, boolean childrenAreAssigned) {
            this.openHierarchy = openHierarchy;
            this.closeHierarchy = closeHierarchy;
            this.childrenSeparator = memberSeparator;
            this.singularChildName = singularChildName;
            this.pluralChildName = pluralChildName;
            this.childrenAreAssigned = childrenAreAssigned;
        }

        public char getOpenHierarchy() {
            return this.openHierarchy;
        }

        public char getCloseHierarchy() {
            return this.closeHierarchy;
        }

        public String getChildrenSeparator() {
            return this.childrenSeparator;
        }

        public String getSingularChildName() {
            return this.singularChildName;
        }

        public String getPluralChildName() {
            return this.pluralChildName;
        }

        public boolean childrenAreAssigned() {
            return this.childrenAreAssigned;
        }
    }
}

