/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.AbstractArgumentAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerHelper;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.data.IArgumentParent;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.kapi.AbstractConstantOrAliasSpec;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.BasicTypeSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ArgumentContainerAttachment
extends AbstractArgumentAttachment
implements IArgumentParent {
    private static final long serialVersionUID = -877452933183814914L;
    private @Nullable List<@NonNull FunctionCallArgumentDescriptor> members;
    private final @NonNull List<@NonNull Serializable> actualArgumentValues;
    private @Nullable BasicTypeSpec basicType;

    public ArgumentContainerAttachment(@NonNull List<@NonNull FunctionCallArgumentDescriptor> members) {
        this.members = members.size() == 0 ? NullUtils.emptyList() : new ArrayList<FunctionCallArgumentDescriptor>(members);
        this.actualArgumentValues = members.size() == 0 ? NullUtils.emptyList() : new ArrayList(members.size());
    }

    public @NonNull List<@NonNull FunctionCallArgumentDescriptor> getMembers() {
        if (this.members != null) {
            return this.members;
        }
        ArrayList<@NonNull FunctionCallArgumentDescriptor> membersToReturn = new ArrayList<FunctionCallArgumentDescriptor>();
        for (Serializable actualArgumentValue : this.actualArgumentValues) {
            membersToReturn.add(FunctionCallArgumentDescriptor.fromValue(actualArgumentValue));
        }
        return membersToReturn;
    }

    @Override
    public @NonNull String getDescriptiveText() {
        if (this.isNull()) {
            return "NULL";
        }
        return (String)NullUtils.neverNull((Object)this.actualArgumentValues.toString());
    }

    public @NonNull Serializable getArgValue(int i) {
        return this.actualArgumentValues.get(i);
    }

    @Override
    public @NonNull IArgument getArgument(int argId) {
        return this.getSerializableArgValueAsIArgument((Serializable)NullUtils.neverNull((Object)this.getArgValue(argId)), argId);
    }

    @Override
    public @NonNull List<@NonNull IArgument> getArguments() {
        ArrayList<@NonNull IArgument> argList = new ArrayList<IArgument>(this.actualArgumentValues.size());
        int i = 0;
        while (i < this.actualArgumentValues.size()) {
            argList.add(this.getSerializableArgValueAsIArgument(this.actualArgumentValues.get(i), i));
            ++i;
        }
        return NullUtils.unmodifiableList(argList);
    }

    @Override
    public @NonNull ArgumentSpec getChildArgumentSpec(int argId) {
        assert (this.basicType != null);
        return (ArgumentSpec)NullUtils.neverNull((Object)this.basicType.getReferencedContainer().getMember().get(argId));
    }

    public void setType(@NonNull BasicTypeSpec basicType) {
        assert (this.parent == null) : "ArgumentContainerAttachment setType must be called before setParent";
        assert (this.members != null);
        @NonNull List<@NonNull FunctionCallArgumentDescriptor> localMembers = this.members;
        this.basicType = basicType;
        int memberIndex = 0;
        while (memberIndex < localMembers.size()) {
            ArgumentSpec childArgumentSpec = basicType.getReferencedContainer().getMember().get(memberIndex);
            assert (childArgumentSpec != null);
            this.actualArgumentValues.add(localMembers.get(memberIndex).getObjectValue(childArgumentSpec));
            Serializable actualArgumentValue = this.actualArgumentValues.get(memberIndex);
            if (actualArgumentValue instanceof IArgumentAttachment) {
                ArgumentContainerHelper.setTypeIfContainer((IArgumentAttachment)actualArgumentValue, childArgumentSpec);
            }
            ++memberIndex;
        }
        this.members = null;
    }

    @Override
    public void setParent(@NonNull IArgumentParent parent, int argIndex) {
        assert (this.basicType != null || this.actualArgumentValues.size() == 0 || this.isNull()) : "ArgumentContainerAttachment setType must be called before setParent for all containers that may have children";
        super.setParent(parent, argIndex);
        int argumentIndex = 0;
        while (argumentIndex < this.actualArgumentValues.size()) {
            Serializable actualArgumentValue = this.actualArgumentValues.get(argumentIndex);
            if (actualArgumentValue instanceof IArgumentAttachment) {
                IArgumentAttachment argumentAttachment = (IArgumentAttachment)actualArgumentValue;
                argumentAttachment.setParent(this, argumentIndex);
            }
            ++argumentIndex;
        }
    }

    public @NonNull ArgumentContainerAttachment getContainer() {
        return this;
    }

    public @Nullable BasicTypeSpec getExtensionType() {
        @Nullable List<@NonNull FunctionCallArgumentDescriptor> localMembers = this.members;
        if (localMembers == null) {
            return null;
        }
        if (localMembers.size() == 0) {
            return null;
        }
        Serializable extensionType = localMembers.get(0).getRawObjectValue();
        extensionType = FunctionCallArgumentDescriptor.convertConstantValue(KapiSpec.VULKAN.basicTypes.VKSTRUCTURETYPE.getUsage(), extensionType);
        if (extensionType instanceof AbstractConstantOrAliasSpec) {
            return ((AbstractConstantOrAliasSpec)((Object)extensionType)).getContainerType();
        }
        return null;
    }

    @Override
    public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
        if (this.isNull()) {
            return ArgumentHierarchyLeaf.nullPointer(this.getArgumentName());
        }
        List<IArgument> args = this.getArguments();
        ArrayList<@NonNull ArgumentHierarchyNode> membersList = new ArrayList<ArgumentHierarchyNode>(args.size());
        for (IArgument arg : args) {
            membersList.add(arg.getArgumentHierarchy());
        }
        return ArgumentHierarchyBranch.structHierarchy(this.getArgumentName(), membersList);
    }
}

