/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.AbstractArgumentAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerAttachment;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.data.IArgumentParent;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.BasicTypeSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ArgumentContainerArrayAttachment
extends AbstractArgumentAttachment
implements IArgumentParent {
    private static final long serialVersionUID = 3519703328937533982L;
    private final @NonNull List<@NonNull ArgumentContainerAttachment> elements;
    private @Nullable ArgumentSpec argumentSpec;

    public ArgumentContainerArrayAttachment(@NonNull List<@NonNull ArgumentContainerAttachment> containers) {
        this.elements = containers.size() == 0 ? NullUtils.emptyList() : new ArrayList<ArgumentContainerAttachment>(containers);
    }

    @Override
    public @NonNull String getDescriptiveText() {
        if (this.isNull()) {
            return "NULL";
        }
        return (String)NullUtils.neverNull((Object)this.elements.toString());
    }

    public @NonNull List<@NonNull ArgumentContainerAttachment> getElements() {
        return this.elements;
    }

    @Override
    public @NonNull IArgumentAttachment getArgument(int argId) {
        return this.elements.get(argId);
    }

    @Override
    public @NonNull ArgumentSpec getChildArgumentSpec(int argId) {
        return (ArgumentSpec)NullUtils.neverNull((Object)this.argumentSpec);
    }

    public void setType(@NonNull ArgumentSpec argumentSpec) {
        this.argumentSpec = argumentSpec;
        int elementIndex = 0;
        while (elementIndex < this.elements.size()) {
            BasicTypeSpec elementBasicType = argumentSpec.getFormat().getArray().getBasicTypeRef().getValue();
            assert (elementBasicType != null);
            this.elements.get(elementIndex).setType(elementBasicType);
            ++elementIndex;
        }
    }

    @Override
    public void setParent(@NonNull IArgumentParent parent, int argIndex) {
        super.setParent(parent, argIndex);
        int elementIndex = 0;
        while (elementIndex < this.elements.size()) {
            this.elements.get(elementIndex).setParent(this, elementIndex);
            ++elementIndex;
        }
    }

    @Override
    public @NonNull List<@NonNull IArgument> getArguments() {
        return NullUtils.unmodifiableList(this.elements);
    }

    @Override
    public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
        if (this.isNull()) {
            return ArgumentHierarchyLeaf.nullPointer(this.getArgumentName());
        }
        List<IArgument> args = this.getArguments();
        ArrayList<@NonNull ArgumentHierarchyNode> elementsList = new ArrayList<ArgumentHierarchyNode>(args.size());
        for (IArgument arg : args) {
            elementsList.add(arg.getArgumentHierarchy());
        }
        return ArgumentHierarchyBranch.arrayHierarchy(this.getArgumentName(), elementsList);
    }
}

