/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.ArrayArgumentAttachment;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractLongsArgAttachment<T>
extends ArrayArgumentAttachment<T> {
    private static final long serialVersionUID = 8836715521026240535L;
    private static final long @NonNull [] EMPTY_LONGS = new long[0];
    private static final @NonNull WeakHashMap<LongArrayWrapper, @Nullable WeakReference<long @Nullable []>> VALUES_CACHE = new WeakHashMap();
    private final long @NonNull [] longs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLongsArgAttachment(@NonNull List<@NonNull Long> longsList) {
        if (longsList.size() == 0) {
            this.longs = EMPTY_LONGS;
        } else {
            long[] cachedLongs;
            long @NonNull [] array = new long[longsList.size()];
            int i = 0;
            while (i < array.length) {
                array[i] = longsList.get(i);
                ++i;
            }
            LongArrayWrapper wrapper = new LongArrayWrapper(array);
            WeakHashMap<LongArrayWrapper, WeakReference<long[]>> weakHashMap = VALUES_CACHE;
            synchronized (weakHashMap) {
                WeakReference<long @Nullable []> cachedListRef = VALUES_CACHE.get(wrapper);
                long[] lArray = cachedLongs = cachedListRef == null ? null : (long[])cachedListRef.get();
                if (cachedLongs == null) {
                    cachedLongs = array;
                    VALUES_CACHE.put(wrapper, new WeakReference<long[]>(array));
                }
            }
            this.longs = cachedLongs;
        }
    }

    protected long getLong(int index) {
        return this.longs[index];
    }

    protected PrimitiveIterator.OfLong primitiveIterator() {
        return Arrays.stream(this.longs).iterator();
    }

    protected @NonNull List<@NonNull Long> asLongsList() {
        ArrayList<@NonNull Long> list = new ArrayList<Long>(this.longs.length);
        long[] lArray = this.longs;
        int n = this.longs.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            list.add(NullUtils.longValueOf((long)l));
            ++n2;
        }
        return list;
    }

    @Override
    public int size() {
        return this.longs.length;
    }

    public int hashCode() {
        return this.longs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractLongsArgAttachment) {
            AbstractLongsArgAttachment other = (AbstractLongsArgAttachment)obj;
            return Arrays.equals(this.longs, other.longs);
        }
        return false;
    }

    private static class LongArrayWrapper {
        private final long @NonNull [] longs;

        private LongArrayWrapper(long @NonNull [] longs) {
            this.longs = longs;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongArrayWrapper) {
                return Arrays.equals(this.longs, ((LongArrayWrapper)obj).longs);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.longs);
        }
    }
}

