/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IFreeAttachment;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractFreeAttachment
implements IFreeAttachment {
    private static final long serialVersionUID = 3435010334533560616L;
    private @Nullable FunctionCall parentFunctionCall;

    @Override
    public Object writeReplace() {
        FunctionCall functionCall = this.getParentFunctionCall();
        assert (functionCall != null);
        int freeAttachmentIndex = functionCall.getFreeAttachmentIndex(this);
        if (freeAttachmentIndex >= 0) {
            return new SerializationProxy(functionCall, freeAttachmentIndex);
        }
        assert (functionCall.hasMidstreamTraceData());
        TraceDataModel model = functionCall.getModel();
        int midstreamIndex = model.writeReplaceMidstreamFreeAttachment(this);
        return new MidstreamSerializationProxy(model, midstreamIndex);
    }

    public void earlyPreProcess(@NonNull TraceStateSnapshot currentState) {
    }

    public abstract void process(@NonNull TraceStateSnapshot var1);

    public <M> void processLightweightPreCallProcessor(@NonNull Class<M> clazz, @NonNull ILightweightAssetProcessorCallbacks<M> callbacks) throws Exception {
    }

    public <M> void processLightweightPostCallProcessor(@NonNull Class<M> clazz, @NonNull ILightweightAssetProcessorCallbacks<M> callbacks) throws Exception {
    }

    public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> @NonNull V processLightweightValue(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject, @NonNull V value) throws Exception {
        return value;
    }

    public void doMidstreamProcessingForAsset(@NonNull TraceStateSnapshot currentState, @NonNull com.arm.mgd.core.asset.IAssetItem assetObject) throws Exception {
        assert (false) : "Not implemented for type " + this.getClass().getSimpleName();
    }

    public <M, P extends IAssetItem<M, ?>> void doMidstreamProcessingForLightweightAsset(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject) throws Exception {
        assert (false) : "Not implemented for type " + this.getClass().getSimpleName();
    }

    public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> @NonNull V doMidstreamProcessingForLightweightAssetValue(@NonNull ILightweightAssetProcessorCallbacks<M> callbacks, @NonNull P assetObject, @NonNull V value) throws Exception {
        assert (false) : "Not implemented for type " + this.getClass().getSimpleName();
        return value;
    }

    @Override
    public void setParentFunctionCall(@NonNull FunctionCall parentFunctionCall) {
        assert (this.parentFunctionCall == null || this.parentFunctionCall == parentFunctionCall) : "setParentFunctionCall must only be called once and should be called by the parent function call when the attachment is added to it";
        this.parentFunctionCall = parentFunctionCall;
    }

    @Override
    public @NonNull FunctionCall getParentFunctionCall() {
        assert (this.parentFunctionCall != null) : "setParentFunctionCall has not been called. It should have been called by the parent function call when the attachment is added to it";
        return this.parentFunctionCall;
    }

    public void setParentMidstreamDataAttachment(@NonNull MidstreamDataAttachment midstreamDataAttachment) {
        this.setParentFunctionCall(midstreamDataAttachment.getParentFunctionCall());
    }

    private static class MidstreamSerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = 6711863070551743895L;
        private final @NonNull TraceDataModel model;
        private final int midstreamAttachmentIndex;

        MidstreamSerializationProxy(@NonNull TraceDataModel model, int midstreamAttachmentIndex) {
            this.model = model;
            this.midstreamAttachmentIndex = midstreamAttachmentIndex;
        }

        @Override
        public Object readResolve() {
            return this.model.readResolveMidstreamFreeAttachment(this.midstreamAttachmentIndex);
        }
    }

    private static class SerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = -3443984650028337911L;
        private final @NonNull FunctionCall functionCall;
        private final int index;

        SerializationProxy(@NonNull FunctionCall functionCall, int index) {
            this.functionCall = functionCall;
            this.index = index;
        }

        @Override
        public Object readResolve() {
            return this.functionCall.getFreeAttachments().get(this.index);
        }
    }
}

