/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.IArgumentAttachment;
import com.arm.mgd.core.target.data.IArgumentParent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractArgumentAttachment
implements IArgumentAttachment {
    private static final long serialVersionUID = -6476138251302806386L;
    protected @Nullable IArgumentParent parent;
    private @Nullable Pointer originalValue;
    private int argId;

    public static <T> T castArgumentValue(Class<T> clazz, Object value, String label) {
        if (value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw new ClassCastException("Failed to convert " + label + " from " + value.getClass().getSimpleName() + " to " + clazz.getSimpleName());
    }

    @Override
    public Object writeReplace() {
        return new SerializationProxy(this);
    }

    @Override
    public void setOriginalPointerValue(@Nullable Pointer originalValue) {
        assert (this.originalValue == null || this.originalValue != null && this.originalValue.equals(originalValue));
        this.originalValue = originalValue;
    }

    @Override
    public @Nullable Pointer getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public @NonNull IArgumentParent getParent() {
        assert (this.parent != null) : "setParent has not been called. It should have been called by the parent when the attachment is added to it";
        return this.parent;
    }

    @Override
    public int getArgumentId() {
        return this.argId;
    }

    @Override
    public void setParent(@NonNull IArgumentParent parent, int argIndex) {
        assert (this.parent == null) : "setParent must only be called once and should be called by the parent when the attachment is added to it";
        this.parent = parent;
        this.argId = argIndex;
    }

    public boolean isNull() {
        return Pointer.NULL.equals(this.originalValue);
    }

    private static class SerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = -3959418186239063963L;
        private final IArgumentParent parent;
        private final int argId;

        SerializationProxy(IArgumentAttachment argAttachment) {
            this.parent = argAttachment.getParent();
            this.argId = argAttachment.getArgumentId();
        }

        @Override
        public Object readResolve() {
            return this.parent.getArgument(this.argId);
        }
    }
}

