/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.target.data;

import com.arm.mgd.core.target.data.ArgumentHierarchyFactory;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.IArgumentParent;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractArgument<K extends Serializable>
implements IArgument {
    private static final long serialVersionUID = 456606910169869149L;
    private final @NonNull K value;
    private final @NonNull IArgumentParent parent;
    private final int argId;

    private AbstractArgument(@NonNull K value, @NonNull IArgumentParent parent, int argId) {
        this.value = value;
        this.parent = parent;
        this.argId = argId;
    }

    public @NonNull K getValue() {
        return this.value;
    }

    @Override
    public @NonNull IArgumentParent getParent() {
        return this.parent;
    }

    @Override
    public int getArgumentId() {
        return this.argId;
    }

    @Override
    public @NonNull String getDescriptiveText() {
        return (String)NullUtils.neverNull((Object)this.getValue().toString());
    }

    public static @NonNull AbstractArgument<?> fromSerializable(@NonNull Serializable argValue, @NonNull IArgumentParent parent, int argId) {
        return new SerializableArgument<Serializable>(argValue, parent, argId);
    }

    private static class SerializableArgument<T extends Serializable>
    extends AbstractArgument<T> {
        private static final long serialVersionUID = 4378191852963046840L;

        SerializableArgument(@NonNull T argValue, @NonNull IArgumentParent parent, int argId) {
            super(argValue, parent, argId);
        }

        @Override
        public @NonNull ArgumentHierarchyNode getArgumentHierarchy() {
            return ArgumentHierarchyFactory.createFromSerializable(this.getArgumentName(), this.getValue());
        }
    }
}

