/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.state;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public class VULKANApiVersion
implements Serializable {
    private static final long serialVersionUID = 4573311684056437281L;
    public static final @NonNull VULKANApiVersion UNKNOWN = new VULKANApiVersion(0, 0, 0){
        private static final long serialVersionUID = 7770533379818786442L;

        @Override
        public @NonNull String getName() {
            return "VULKAN_UNKNOWN";
        }
    };
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;

    private VULKANApiVersion(int major, int minor, int patch) {
        assert (major < 1024);
        assert (minor < 1024);
        assert (patch < 4096);
        this.majorVersion = major;
        this.minorVersion = minor;
        this.patchVersion = patch;
    }

    public static final VULKANApiVersion fromVersion(int combinedVersion) {
        int major = combinedVersion >> 22 & 0x3FF;
        int minor = combinedVersion >> 12 & 0x3FF;
        int patch = combinedVersion & 0xFFF;
        return new VULKANApiVersion(major, minor, patch);
    }

    public static final VULKANApiVersion fromVersion(int major, int minor, int patch) {
        return new VULKANApiVersion(major, minor, patch);
    }

    public @NonNull String getName() {
        return "VULKAN_" + this.majorVersion + "_" + this.minorVersion + "_" + this.patchVersion;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + this.patchVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VULKANApiVersion)) {
            return false;
        }
        VULKANApiVersion other = (VULKANApiVersion)obj;
        return this.majorVersion == other.majorVersion && this.minorVersion == other.minorVersion && this.patchVersion == other.patchVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }
}

