/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.state;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public final class StateValue
implements Serializable {
    private static final @NonNull String UNKNOWN_STRING = "<unknown>";
    public static final @NonNull StateValue UNKNOWN = new StateValue("<unknown>");
    private static final long serialVersionUID = -6124127872667135814L;
    public final Object value;

    public static Object parseObjectValue(Object originalValue) {
        if (originalValue == null || originalValue instanceof Number || originalValue instanceof AbstractConstantOrAliasSpecExtended) {
            return originalValue;
        }
        if (originalValue instanceof String) {
            Number newValue = NumberUtils.decodeNumber((String)originalValue);
            if (newValue != null) {
                return newValue;
            }
            AbstractConstantOrAliasSpecExtended constant = KapiSpec.findConstantByName((String)originalValue);
            if (constant != null) {
                return constant;
            }
            if (UNKNOWN_STRING.equals(originalValue)) {
                return UNKNOWN_STRING;
            }
        } else if (originalValue instanceof Pointer) {
            return originalValue;
        }
        return originalValue;
    }

    public StateValue(Object value) {
        this.value = StateValue.parseObjectValue(value);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != StateValue.class) {
            return false;
        }
        Object oValue = ((StateValue)obj).value;
        if (this.value == oValue) {
            return true;
        }
        if (this.value == null || oValue == null) {
            return false;
        }
        if (NumberUtils.isFPNumber(this.value) && NumberUtils.isFPNumber(oValue)) {
            return ((Number)this.value).doubleValue() == ((Number)oValue).doubleValue();
        }
        if (NumberUtils.isIntNumber(this.value) && NumberUtils.isIntNumber(oValue)) {
            return ((Number)this.value).longValue() == ((Number)oValue).longValue();
        }
        return this.value.equals(oValue);
    }

    public Long getValueAsLong() {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        if (this.value == null || this.value.equals(UNKNOWN_STRING)) {
            return null;
        }
        return NumberUtils.valueOfLongDecimalOrHex((String)NullUtils.neverNull((Object)this.value.toString()));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "StateValue(" + this.value + ")";
    }

    Object readResolve() {
        if (StateValue.UNKNOWN.value.equals(this.value)) {
            return UNKNOWN;
        }
        return this;
    }
}

