/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.state;

import com.arm.mgd.core.asset.TargetAssetMap;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateData;
import com.arm.mgd.kapi.gen.ScopeSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class GraphicsContextGroup
implements Serializable {
    private static final long serialVersionUID = -5907852603653027844L;
    public final int id;
    public final Map<KapiSpec, TargetAssetMap> assetData;
    private final @NonNull List<@NonNull GraphicsContext> associatedContexts;

    public GraphicsContextGroup(@NonNull TraceStateData traceStateData, int id, @NonNull FunctionCall currentFunctionCall) {
        this.id = id;
        this.associatedContexts = new ArrayList<GraphicsContext>();
        this.assetData = new HashMap<KapiSpec, TargetAssetMap>();
        for (KapiSpec kapiSpec : KapiSpec.getAvailableKapiSpecs()) {
            TargetAssetMap assetMap = new TargetAssetMap(traceStateData, kapiSpec, ScopeSpec.SHARED, currentFunctionCall);
            this.assetData.put(kapiSpec, assetMap);
        }
    }

    public int hashCode() {
        return Integer.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GraphicsContextGroup) {
            GraphicsContextGroup that = (GraphicsContextGroup)obj;
            return this.id == that.id;
        }
        return false;
    }

    void addContext(@NonNull GraphicsContext graphicsContext) {
        this.associatedContexts.add(graphicsContext);
    }

    public @NonNull List<@NonNull GraphicsContext> getAssociatedContexts() {
        return Collections.unmodifiableList(this.associatedContexts);
    }

    public void clearGlobalAssetState(@NonNull FunctionCall currentFunctionCall) {
        for (GraphicsContext context : this.associatedContexts) {
            context.clearGlobalAssetState(currentFunctionCall);
        }
        for (TargetAssetMap assetMap : this.assetData.values()) {
            assetMap.clearGlobalAssetState(currentFunctionCall);
        }
    }

    public boolean isGlobalGroup() {
        return this.associatedContexts.size() == 1 && this.associatedContexts.get(0).isGlobalContext();
    }
}

