/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.state;

import com.arm.mgd.core.asset.TargetAssetMap;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.state.GLESApiVersion;
import com.arm.mgd.core.state.GraphicsContextGroup;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateData;
import com.arm.mgd.kapi.gen.ScopeSpec;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GraphicsContext
implements Serializable {
    private static final long serialVersionUID = -8836883142857638192L;
    private final long handle;
    private final long index;
    public final GraphicsContextGroup contextGroup;
    public final @NonNull Map<KapiSpec, TargetAssetMap> assetData = new HashMap<KapiSpec, TargetAssetMap>();
    private final @NonNull GLESApiVersion apiVersion;
    private final @Nullable FunctionCall creatingFunction;

    public long getHandle() {
        return this.handle;
    }

    public long getIndex() {
        return this.index;
    }

    public @NonNull GLESApiVersion getApiVersion() {
        return this.apiVersion;
    }

    private GraphicsContext(long index, long contextHandle, @NonNull GLESApiVersion apiVersion, @NonNull TraceStateData traceStateData, GraphicsContext parentContext, @NonNull FunctionCall currentFunctionCall) {
        this.index = index;
        this.handle = contextHandle;
        this.apiVersion = apiVersion;
        this.creatingFunction = currentFunctionCall;
        if (parentContext != null) {
            assert (!this.isGlobalContext());
            assert (!parentContext.isGlobalContext());
            this.contextGroup = parentContext.contextGroup;
        } else {
            this.contextGroup = new GraphicsContextGroup(traceStateData, traceStateData.getTraceStateSnapshot().getModel().allocateNewContextGroupId(), currentFunctionCall);
        }
        this.contextGroup.addContext(this);
        for (KapiSpec kapiSpec : KapiSpec.getAvailableKapiSpecs()) {
            TargetAssetMap assetMap = new TargetAssetMap(traceStateData, kapiSpec, this.handle != 0L ? ScopeSpec.LOCAL : null, currentFunctionCall);
            this.assetData.put(kapiSpec, assetMap);
        }
    }

    public String toString() {
        return "GraphicsContext id=" + this.handle;
    }

    public static @NonNull GraphicsContext create(long index, Pointer contextHandle, @NonNull GLESApiVersion apiVersion, @NonNull TraceStateData traceStateData, GraphicsContext parentContext, @NonNull FunctionCall currentFunctionCall) {
        if (contextHandle == null) {
            assert (parentContext == null);
            return new GraphicsContext(0L, 0L, apiVersion, traceStateData, parentContext, currentFunctionCall);
        }
        return new GraphicsContext(index, contextHandle.address(), apiVersion, traceStateData, parentContext, currentFunctionCall);
    }

    public static GLESApiVersion getApiVersion(@NonNull FunctionCall fc) {
        assert (KapiSpec.EGL.functions.EGLCREATECONTEXT.equals(fc.getFunctionSpec()));
        if (fc.hasError()) {
            return null;
        }
        GLESApiVersion glesApiVersion = GLESApiVersion.GLES1x;
        long EGL_CONTEXT_MAJOR_VERSION = KapiSpec.EGL.constants.EGL_CONTEXT_CLIENT_VERSION.getResolvedValue();
        long EGL_CONTEXT_MINOR_VERSION = KapiSpec.EGL.constants.EGL_CONTEXT_MINOR_VERSION_KHR.getResolvedValue();
        Long majorValue = null;
        Long minorValue = null;
        LongsArgAttachment attributesArg = EGL.EglCreateContextDecorator.getArgumentAttrib_list(fc);
        int i = 0;
        while (i + 1 < attributesArg.size()) {
            long attribute = attributesArg.getLong(i);
            long value = attributesArg.getLong(i + 1);
            if (attribute == EGL_CONTEXT_MAJOR_VERSION) {
                majorValue = value;
            } else if (attribute == EGL_CONTEXT_MINOR_VERSION) {
                minorValue = value;
            }
            i += 2;
        }
        if (majorValue != null && minorValue != null) {
            glesApiVersion = GLESApiVersion.fromVersion(majorValue, minorValue);
        } else if (majorValue != null) {
            glesApiVersion = GLESApiVersion.fromVersion(majorValue, 0L);
        }
        return glesApiVersion;
    }

    public int hashCode() {
        return Long.hashCode(this.handle);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GraphicsContext) {
            GraphicsContext that = (GraphicsContext)obj;
            return this.handle == that.handle && this.contextGroup.equals(that.contextGroup) && this.apiVersion == that.apiVersion;
        }
        return false;
    }

    public @Nullable FunctionCall getCreatingFunction() {
        return this.creatingFunction;
    }

    public void clearGlobalAssetState(@NonNull FunctionCall currentFunctionCall) {
        for (TargetAssetMap assetMap : this.assetData.values()) {
            assetMap.clearGlobalAssetState(currentFunctionCall);
        }
    }

    public boolean isGlobalContext() {
        return this.handle == 0L;
    }
}

