/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.state;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public class GLESApiVersion
implements Serializable {
    private static final long serialVersionUID = -9220990326147526909L;
    public static final @NonNull GLESApiVersion GLES1x = new GLESApiVersion(1, 1);
    public static final @NonNull GLESApiVersion GLES20 = new GLESApiVersion(2, 0);
    public static final @NonNull GLESApiVersion GLES30 = new GLESApiVersion(3, 0);
    public static final @NonNull GLESApiVersion GLES31 = new GLESApiVersion(3, 1);
    public static final @NonNull GLESApiVersion GLES32 = new GLESApiVersion(3, 2);
    public static final @NonNull GLESApiVersion UNKNOWN = new GLESApiVersion(0, 0){
        private static final long serialVersionUID = 8979336723186058343L;

        @Override
        public @NonNull String getName() {
            return "UNKNOWN";
        }
    };
    private final int majorVersion;
    private final int minorVersion;

    private GLESApiVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    public static final @NonNull GLESApiVersion fromVersion(long major, long minor) {
        if (major == 1L) {
            return GLES1x;
        }
        if (major == 2L) {
            return GLES20;
        }
        if (major == 3L && minor == 0L) {
            return GLES30;
        }
        if (major == 3L && minor == 1L) {
            return GLES31;
        }
        if (major == 3L && minor == 2L) {
            return GLES32;
        }
        return new GLESApiVersion((int)major, (int)minor);
    }

    public @NonNull String getName() {
        return "GLES" + this.majorVersion + this.minorVersion;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GLESApiVersion)) {
            return false;
        }
        GLESApiVersion other = (GLESApiVersion)obj;
        return this.majorVersion == other.majorVersion && this.minorVersion == other.minorVersion;
    }
}

