/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyFloat;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyUtils {
    public static final @NonNull PyObject PyNone = (PyObject)NullUtils.neverNull((Object)Py.None);
    public static final @NonNull PyBoolean PyTrue = (PyBoolean)NullUtils.neverNull((Object)Py.True);
    public static final @NonNull PyBoolean PyFalse = (PyBoolean)NullUtils.neverNull((Object)Py.False);

    public static @NonNull PyBoolean toPyBool(boolean bool) {
        return bool ? PyTrue : PyFalse;
    }

    public static @NonNull PyObject create(@Nullable Boolean value) {
        if (value == null) {
            return PyNone;
        }
        if (value.booleanValue()) {
            return PyTrue;
        }
        return PyFalse;
    }

    public static @NonNull PyObject create(@Nullable Long value) {
        if (value == null) {
            return PyNone;
        }
        return new PyLong(value.longValue());
    }

    public static @NonNull PyObject create(@Nullable Float value) {
        if (value == null) {
            return PyNone;
        }
        return new PyFloat(value.doubleValue());
    }

    public static @NonNull PyObject create(@Nullable String value) {
        if (value == null) {
            return PyNone;
        }
        return new PyString(value);
    }

    public static @NonNull PyObject create(@Nullable List<@NonNull Float> values) {
        if (values == null) {
            return PyNone;
        }
        PyList list = new PyList();
        for (Float value : values) {
            list.add((Object)PyUtils.create(value));
        }
        return list;
    }
}

