/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.scripting.python;

import com.arm.mgd.core.scripting.FrameProxy;
import com.arm.mgd.core.scripting.FunctionCallProxy;
import com.arm.mgd.core.scripting.ProcessProxy;
import com.arm.mgd.core.scripting.ProxyObject;
import com.arm.mgd.core.scripting.python.PyDocs;
import com.arm.mgd.core.scripting.python.PyFrame;
import com.arm.mgd.core.scripting.python.PyFunctionCall;
import com.arm.mgd.core.scripting.python.PyProxyObject;
import com.arm.mgd.core.util.LazyObjectGenerator;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.python.core.PyList;
import org.python.core.PyString;

@PyDocs.PyExpose
public class PyProcess
extends PyProxyObject {
    private static final long serialVersionUID = 4103844828184549279L;
    private final @NonNull ProcessProxy proxy;
    private final @NonNull LazyObjectGenerator<List<@NonNull PyFunctionCall>> functionCalls;
    private final @NonNull LazyObjectGenerator<List<@NonNull PyFunctionCall>> eglAndGlesFunctionCalls;
    private final @NonNull LazyObjectGenerator<List<@NonNull PyFunctionCall>> clFunctionCalls;
    private final @NonNull LazyObjectGenerator<List<@NonNull PyFunctionCall>> vulkanFunctionCalls;
    private final @NonNull LazyObjectGenerator<List<@NonNull PyFrame>> frames;

    public PyProcess(final @NonNull ProcessProxy proxy) {
        this.proxy = proxy;
        this.functionCalls = new LazyObjectGenerator<List<PyFunctionCall>>(){

            @Override
            protected @NonNull List<@NonNull PyFunctionCall> generateObject() {
                @NonNull ArrayList<@NonNull PyFunctionCall> functionList = new ArrayList<PyFunctionCall>(proxy.getFunctionCalls().size());
                for (FunctionCallProxy fc : proxy.getFunctionCalls()) {
                    functionList.add(new PyFunctionCall(fc));
                }
                return NullUtils.unmodifiableList(functionList);
            }
        };
        this.eglAndGlesFunctionCalls = new LazyObjectGenerator<List<PyFunctionCall>>(){

            @Override
            protected @NonNull List<@NonNull PyFunctionCall> generateObject() {
                @NonNull ArrayList<@NonNull PyFunctionCall> eglAndGlesfunctionList = new ArrayList<PyFunctionCall>();
                for (PyFunctionCall fc : PyProcess.this.functionCalls.get()) {
                    if (!fc.is_egl_call().getBooleanValue() && !fc.is_gles_call().getBooleanValue()) continue;
                    eglAndGlesfunctionList.add(fc);
                }
                eglAndGlesfunctionList.trimToSize();
                return NullUtils.unmodifiableList(eglAndGlesfunctionList);
            }
        };
        this.clFunctionCalls = new LazyObjectGenerator<List<PyFunctionCall>>(){

            @Override
            protected @NonNull List<@NonNull PyFunctionCall> generateObject() {
                @NonNull ArrayList<@NonNull PyFunctionCall> clfunctionList = new ArrayList<PyFunctionCall>();
                for (PyFunctionCall fc : PyProcess.this.functionCalls.get()) {
                    if (!fc.is_cl_call().getBooleanValue()) continue;
                    clfunctionList.add(fc);
                }
                clfunctionList.trimToSize();
                return NullUtils.unmodifiableList(clfunctionList);
            }
        };
        this.vulkanFunctionCalls = new LazyObjectGenerator<List<PyFunctionCall>>(){

            @Override
            protected @NonNull List<@NonNull PyFunctionCall> generateObject() {
                @NonNull ArrayList<@NonNull PyFunctionCall> vulkanFunctionList = new ArrayList<PyFunctionCall>();
                for (PyFunctionCall fc : PyProcess.this.functionCalls.get()) {
                    if (!fc.is_vulkan_call().getBooleanValue()) continue;
                    vulkanFunctionList.add(fc);
                }
                vulkanFunctionList.trimToSize();
                return NullUtils.unmodifiableList(vulkanFunctionList);
            }
        };
        this.frames = new LazyObjectGenerator<List<PyFrame>>(){

            @Override
            protected @NonNull List<@NonNull PyFrame> generateObject() {
                @NonNull ArrayList<@NonNull PyFrame> frameList = new ArrayList<PyFrame>(proxy.getFrames().size());
                for (FrameProxy frame : proxy.getFrames()) {
                    frameList.add(new PyFrame(frame, PyProcess.this));
                }
                return frameList;
            }
        };
    }

    @PyDocs.PyExpose
    public @NonNull PyList function_calls() {
        return new PyList((Collection)this.functionCalls.get());
    }

    @PyDocs.PyExpose
    public @NonNull PyList egl_and_gles_function_calls() {
        return new PyList((Collection)this.eglAndGlesFunctionCalls.get());
    }

    @PyDocs.PyExpose
    public @NonNull PyList cl_function_calls() {
        return new PyList((Collection)this.clFunctionCalls.get());
    }

    @PyDocs.PyExpose
    public @NonNull PyList vulkan_function_calls() {
        return new PyList((Collection)this.vulkanFunctionCalls.get());
    }

    @PyDocs.PyExpose
    public @NonNull PyList frames() {
        return new PyList((Collection)this.frames.get());
    }

    @PyDocs.PyExpose
    public @NonNull PyString name() {
        return new PyString(this.proxy.getName());
    }

    protected @NonNull List<@NonNull PyFunctionCall> getFunctionCalls() {
        return this.functionCalls.get();
    }

    public PyString __repr__() {
        return this.name();
    }

    @Override
    protected @NonNull ProxyObject getProxyObject() {
        return this.proxy;
    }
}

